/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    STRING_KEYED_JDBC_STORE("stringKeyedJdbcStore"),
    BINARY_KEYED_JDBC_STORE("binaryKeyedJdbcStore"),
    MIXED_KEYED_JDBC_STORE("mixedKeyedJdbcStore"),
    BINARY_KEYED_TABLE("binaryKeyedTable"),
    STRING_KEYED_TABLE("stringKeyedTable"),
    DATA_COLUMN("dataColumn"),
    ID_COLUMN("idColumn"),
    TIMESTAMP_COLUMN("timestampColumn");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>(8);
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

