/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.configuration;

import org.infinispan.configuration.BuiltBy;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.LegacyLoaderAdapter;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStoreConfig;
import org.infinispan.loaders.jdbc.configuration.AbstractJdbcCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcBinaryCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.util.TypedProperties;

@BuiltBy(value=JdbcBinaryCacheStoreConfigurationBuilder.class)
public class JdbcBinaryCacheStoreConfiguration
extends AbstractJdbcCacheStoreConfiguration
implements LegacyLoaderAdapter<JdbcBinaryCacheStoreConfig> {
    private final TableManipulationConfiguration table;

    JdbcBinaryCacheStoreConfiguration(TableManipulationConfiguration table, String driverClass, String connectionUrl, String userName, String password, String connectionFactoryClass, String datasourceJndiLocation, long lockAcquistionTimeout, int lockConcurrencyLevel, boolean purgeOnStartup, boolean purgeSynchronously, int purgerThreads, boolean fetchPersistentState, boolean ignoreModifications, TypedProperties properties, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore) {
        super(driverClass, connectionUrl, userName, password, connectionFactoryClass, datasourceJndiLocation, lockAcquistionTimeout, lockConcurrencyLevel, purgeOnStartup, purgeSynchronously, purgerThreads, fetchPersistentState, ignoreModifications, properties, async, singletonStore);
        this.table = table;
    }

    public TableManipulationConfiguration table() {
        return this.table;
    }

    public JdbcBinaryCacheStoreConfig adapt() {
        JdbcBinaryCacheStoreConfig config = new JdbcBinaryCacheStoreConfig();
        config.fetchPersistentState(this.fetchPersistentState());
        config.ignoreModifications(this.ignoreModifications());
        config.purgeOnStartup(this.purgeOnStartup());
        config.purgeSynchronously(this.purgeSynchronously());
        config.purgerThreads(this.purgerThreads());
        config.setLockAcquistionTimeout(this.lockAcquistionTimeout());
        config.setLockConcurrencyLevel(this.lockConcurrencyLevel());
        config.setConnectionFactoryClass(this.connectionFactoryClass());
        config.setConnectionUrl(this.connectionUrl());
        config.setDatasourceJndiLocation(this.datasource());
        config.setDriverClass(this.driverClass());
        config.setUserName(this.userName());
        config.setPassword(this.password());
        config.setCreateTableOnStart(this.table.createOnStart());
        config.setDropTableOnExit(this.table.dropOnExit());
        config.setBatchSize(this.table.batchSize());
        config.setFetchSize(this.table.fetchSize());
        config.setCacheName(this.table.cacheName());
        config.setDataColumnName(this.table.dataColumnName());
        config.setDataColumnType(this.table.dataColumnType());
        config.setIdColumnName(this.table.idColumnName());
        config.setIdColumnType(this.table.idColumnType());
        config.setTimestampColumnName(this.table.timestampColumnName());
        config.setTimestampColumnType(this.table.timestampColumnType());
        config.setTableNamePrefix(this.table.tableNamePrefix());
        return config;
    }

    public String toString() {
        return "JdbcBinaryBasedCacheStoreConfiguration [table=" + this.table + ", driverClass()=" + this.driverClass() + ", connectionUrl()=" + this.connectionUrl() + ", userName()=" + this.userName() + ", password()=" + this.password() + ", connectionFactoryClass()=" + this.connectionFactoryClass() + ", datasourceJndiLocation()=" + this.datasource() + ", lockAcquistionTimeout()=" + this.lockAcquistionTimeout() + ", lockConcurrencyLevel()=" + this.lockConcurrencyLevel() + ", async()=" + this.async() + ", singletonStore()=" + this.singletonStore() + ", purgeOnStartup()=" + this.purgeOnStartup() + ", purgeSynchronously()=" + this.purgeSynchronously() + ", purgerThreads()=" + this.purgerThreads() + ", fetchPersistentState()=" + this.fetchPersistentState() + ", ignoreModifications()=" + this.ignoreModifications() + ", properties()=" + this.properties() + "]";
    }
}

