/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.configuration;

import org.infinispan.configuration.BuiltBy;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.LegacyLoaderAdapter;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.AbstractJdbcCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStoreConfig;
import org.infinispan.util.TypedProperties;

@BuiltBy(value=JdbcMixedCacheStoreConfigurationBuilder.class)
public class JdbcMixedCacheStoreConfiguration
extends AbstractJdbcCacheStoreConfiguration
implements LegacyLoaderAdapter<JdbcMixedCacheStoreConfig> {
    private final TableManipulationConfiguration binaryTable;
    private final TableManipulationConfiguration stringTable;
    private final String key2StringMapper;

    protected JdbcMixedCacheStoreConfiguration(String key2StringMapper, TableManipulationConfiguration binaryTable, TableManipulationConfiguration stringTable, String driverClass, String connectionUrl, String userName, String password, String connectionFactoryClass, String datasourceJndiLocation, long lockAcquistionTimeout, int lockConcurrencyLevel, boolean purgeOnStartup, boolean purgeSynchronously, int purgerThreads, boolean fetchPersistentState, boolean ignoreModifications, TypedProperties properties, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore) {
        super(driverClass, connectionUrl, userName, password, connectionFactoryClass, datasourceJndiLocation, lockAcquistionTimeout, lockConcurrencyLevel, purgeOnStartup, purgeSynchronously, purgerThreads, fetchPersistentState, ignoreModifications, properties, async, singletonStore);
        this.key2StringMapper = key2StringMapper;
        this.binaryTable = binaryTable;
        this.stringTable = stringTable;
    }

    public String key2StringMapper() {
        return this.key2StringMapper;
    }

    public TableManipulationConfiguration binaryTable() {
        return this.binaryTable;
    }

    public TableManipulationConfiguration stringTable() {
        return this.stringTable;
    }

    public JdbcMixedCacheStoreConfig adapt() {
        JdbcMixedCacheStoreConfig config = new JdbcMixedCacheStoreConfig();
        config.fetchPersistentState(this.fetchPersistentState());
        config.ignoreModifications(this.ignoreModifications());
        config.purgeOnStartup(this.purgeOnStartup());
        config.purgeSynchronously(this.purgeSynchronously());
        config.purgerThreads(this.purgerThreads());
        config.setLockAcquistionTimeout(this.lockAcquistionTimeout());
        config.setLockConcurrencyLevel(this.lockConcurrencyLevel());
        config.setConnectionFactoryClass(this.connectionFactoryClass());
        config.setConnectionUrl(this.connectionUrl());
        config.setDatasourceJndiLocation(this.datasource());
        config.setDriverClass(this.driverClass());
        config.setUserName(this.userName());
        config.setPassword(this.password());
        config.setKey2StringMapperClass(this.key2StringMapper);
        config.setCreateTableOnStartForBinary(this.binaryTable().createOnStart());
        config.setDropTableOnExitForBinary(this.binaryTable().dropOnExit());
        config.setTableNamePrefixForBinary(this.binaryTable().tableNamePrefix());
        config.setDataColumnNameForBinary(this.binaryTable().dataColumnName());
        config.setDataColumnTypeForBinary(this.binaryTable().dataColumnType());
        config.setIdColumnNameForBinary(this.binaryTable().idColumnName());
        config.setIdColumnTypeForBinary(this.binaryTable().idColumnType());
        config.setTimestampColumnNameForBinary(this.binaryTable().timestampColumnName());
        config.setTimestampColumnTypeForBinary(this.binaryTable().timestampColumnType());
        config.setCreateTableOnStartForStrings(this.stringTable().createOnStart());
        config.setDropTableOnExitForStrings(this.stringTable().dropOnExit());
        config.setTableNamePrefixForStrings(this.stringTable().tableNamePrefix());
        config.setDataColumnNameForStrings(this.stringTable().dataColumnName());
        config.setDataColumnTypeForStrings(this.stringTable().dataColumnType());
        config.setIdColumnNameForStrings(this.stringTable().idColumnName());
        config.setIdColumnTypeForStrings(this.stringTable().idColumnType());
        config.setTimestampColumnNameForStrings(this.stringTable().timestampColumnName());
        config.setTimestampColumnTypeForStrings(this.stringTable().timestampColumnType());
        return config;
    }

    public String toString() {
        return "JdbcMixedCacheStoreConfiguration [binaryTable=" + this.binaryTable + ", stringTable=" + this.stringTable + ", key2StringMapper=" + this.key2StringMapper + ", getDriverClass()=" + this.driverClass() + ", getConnectionUrl()=" + this.connectionUrl() + ", getUserName()=" + this.userName() + ", getPassword()=" + this.password() + ", getConnectionFactoryClass()=" + this.connectionFactoryClass() + ", getDatasourceJndiLocation()=" + this.datasource() + ", lockAcquistionTimeout()=" + this.lockAcquistionTimeout() + ", lockConcurrencyLevel()=" + this.lockConcurrencyLevel() + ", async()=" + this.async() + ", singletonStore()=" + this.singletonStore() + ", purgeOnStartup()=" + this.purgeOnStartup() + ", purgeSynchronously()=" + this.purgeSynchronously() + ", purgerThreads()=" + this.purgerThreads() + ", fetchPersistentState()=" + this.fetchPersistentState() + ", ignoreModifications()=" + this.ignoreModifications() + ", properties()=" + this.properties() + "]";
    }
}

