/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.configuration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcBinaryCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcStringBasedCacheStoreConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.jdbc.configuration.XmlFileParsingTest")
public class XmlFileParsingTest
extends AbstractInfinispanTest {
    private EmbeddedCacheManager cacheManager;

    @AfterMethod(alwaysRun=true)
    public void cleanup() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    public void testStringKeyedJdbcStore() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.2 http://www.infinispan.org/schemas/infinispan-config-5.2.xsd\"\n      xmlns=\"urn:infinispan:config:5.2\">   <default>\n     <loaders>\n       <stringKeyedJdbcStore xmlns=\"urn:infinispan:config:jdbc:5.2\" >\n         <connectionPool connectionUrl=\"jdbc:h2:mem:infinispan;DB_CLOSE_DELAY=-1\" username=\"dbuser\" password=\"dbpass\" />\n         <stringKeyedTable prefix=\"entry\" fetchSize=\"34\" batchSize=\"99\">\n           <idColumn name=\"id\" type=\"VARCHAR\" />\n           <dataColumn name=\"datum\" type=\"BINARY\" />\n           <timestampColumn name=\"version\" type=\"BIGINT\" />\n         </stringKeyedTable>\n         <async enabled=\"true\" />\n       </stringKeyedJdbcStore>\n     </loaders>\n   </default>\n</infinispan>";
        JdbcStringBasedCacheStoreConfiguration store = (JdbcStringBasedCacheStoreConfiguration)this.buildCacheManagerWithCacheStore(config);
        assert (store.table().batchSize() == 99);
        assert (store.table().fetchSize() == 34);
        assert (store.table().dataColumnType().equals("BINARY"));
        assert (store.table().timestampColumnName().equals("version"));
        assert (store.async().enabled());
    }

    public void testBinaryKeyedJdbcStore() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.2 http://www.infinispan.org/schemas/infinispan-config-5.2.xsd\"\n      xmlns=\"urn:infinispan:config:5.2\">   <default>\n     <loaders>\n       <binaryKeyedJdbcStore xmlns=\"urn:infinispan:config:jdbc:5.2\" ignoreModifications=\"true\">\n         <simpleConnection connectionUrl=\"jdbc:h2:mem:infinispan;DB_CLOSE_DELAY=-1\" username=\"dbuser\" password=\"dbpass\" />\n         <binaryKeyedTable prefix=\"bucket\" fetchSize=\"34\" batchSize=\"99\">\n           <idColumn name=\"id\" type=\"BINARY\" />\n           <dataColumn name=\"datum\" type=\"BINARY\" />\n           <timestampColumn name=\"version\" type=\"BIGINT\" />\n         </binaryKeyedTable>\n         <singletonStore enabled=\"true\" />\n       </binaryKeyedJdbcStore>\n     </loaders>\n   </default>\n</infinispan>";
        JdbcBinaryCacheStoreConfiguration store = (JdbcBinaryCacheStoreConfiguration)this.buildCacheManagerWithCacheStore(config);
        assert (store.ignoreModifications());
        assert (store.table().tableNamePrefix().equals("bucket"));
        assert (store.table().batchSize() == 99);
        assert (store.table().fetchSize() == 34);
        assert (store.table().dataColumnType().equals("BINARY"));
        assert (store.table().timestampColumnName().equals("version"));
        assert (store.singletonStore().enabled());
    }

    public void testMixedKeyedJdbcStore() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.2 http://www.infinispan.org/schemas/infinispan-config-5.2.xsd\"\n      xmlns=\"urn:infinispan:config:5.2\">   <default>\n     <loaders>\n       <mixedKeyedJdbcStore xmlns=\"urn:infinispan:config:jdbc:5.2\" >\n         <dataSource jndiUrl=\"java:MyDataSource\" />\n         <stringKeyedTable prefix=\"entry\" fetchSize=\"34\" batchSize=\"99\">\n           <idColumn name=\"id\" type=\"VARCHAR\" />\n           <dataColumn name=\"datum\" type=\"BINARY\" />\n           <timestampColumn name=\"version\" type=\"BIGINT\" />\n         </stringKeyedTable>\n         <binaryKeyedTable prefix=\"bucket\" fetchSize=\"44\" batchSize=\"79\">\n           <idColumn name=\"id\" type=\"BINARY\" />\n           <dataColumn name=\"datum\" type=\"BINARY\" />\n           <timestampColumn name=\"version\" type=\"BIGINT\" />\n         </binaryKeyedTable>\n         <async enabled=\"true\" />\n         <singletonStore enabled=\"true\" />\n       </mixedKeyedJdbcStore>\n     </loaders>\n   </default>\n</infinispan>";
        JdbcMixedCacheStoreConfiguration store = (JdbcMixedCacheStoreConfiguration)this.buildCacheManagerWithCacheStore(config);
        assert (store.stringTable().tableNamePrefix().equals("entry"));
        assert (store.stringTable().batchSize() == 99);
        assert (store.stringTable().fetchSize() == 34);
        assert (store.stringTable().dataColumnType().equals("BINARY"));
        assert (store.stringTable().timestampColumnName().equals("version"));
        assert (store.binaryTable().tableNamePrefix().equals("bucket"));
        assert (store.binaryTable().batchSize() == 79);
        assert (store.binaryTable().fetchSize() == 44);
        assert (store.binaryTable().dataColumnType().equals("BINARY"));
        assert (store.binaryTable().timestampColumnName().equals("version"));
        assert (store.async().enabled());
        assert (store.singletonStore().enabled());
    }

    private CacheLoaderConfiguration buildCacheManagerWithCacheStore(String config) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        this.cacheManager = TestCacheManagerFactory.fromStream((InputStream)is);
        assert (this.cacheManager.getDefaultCacheConfiguration().loaders().cacheLoaders().size() == 1);
        return (CacheLoaderConfiguration)this.cacheManager.getDefaultCacheConfiguration().loaders().cacheLoaders().get(0);
    }
}

