/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.binary;

import java.io.Serializable;
import org.infinispan.Cache;
import org.infinispan.CacheImpl;
import org.infinispan.loaders.BaseCacheStoreTest;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStore;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStoreConfig;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.mockito.Mockito;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.binary.JdbcBinaryCacheStoreTest")
public class JdbcBinaryCacheStoreTest
extends BaseCacheStoreTest {
    protected CacheStore createCacheStore() throws Exception {
        ConnectionFactoryConfig connectionFactoryConfig = UnitTestDatabaseManager.getUniqueConnectionFactoryConfig();
        TableManipulation tm = UnitTestDatabaseManager.buildBinaryTableManipulation();
        JdbcBinaryCacheStoreConfig config = new JdbcBinaryCacheStoreConfig(connectionFactoryConfig, tm);
        config.setPurgeSynchronously(Boolean.valueOf(true));
        JdbcBinaryCacheStore jdbcBucketCacheStore = new JdbcBinaryCacheStore();
        jdbcBucketCacheStore.init((CacheLoaderConfig)config, (Cache)new CacheImpl("aName"), this.getMarshaller());
        jdbcBucketCacheStore.start();
        assert (jdbcBucketCacheStore.getConnectionFactory() != null);
        return jdbcBucketCacheStore;
    }

    public void testNotCreateConnectionFactory() throws Exception {
        JdbcBinaryCacheStore jdbcBucketCacheStore = new JdbcBinaryCacheStore();
        JdbcBinaryCacheStoreConfig config = new JdbcBinaryCacheStoreConfig(false);
        config.setCreateTableOnStart(false);
        jdbcBucketCacheStore.init((CacheLoaderConfig)config, (Cache)new CacheImpl("aName"), (StreamingMarshaller)new TestObjectStreamMarshaller());
        jdbcBucketCacheStore.start();
        assert (jdbcBucketCacheStore.getConnectionFactory() == null);
        ConnectionFactory connectionFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        TableManipulation tableManipulation = (TableManipulation)Mockito.mock(TableManipulation.class);
        config.setTableManipulation(tableManipulation);
        tableManipulation.start(connectionFactory);
        tableManipulation.setCacheName("aName");
        jdbcBucketCacheStore.doConnectionFactoryInitialization(connectionFactory);
        tableManipulation.stop();
        jdbcBucketCacheStore.stop();
    }

    public void testPurgeExpired() throws Exception {
        super.testPurgeExpired();
        UnitTestDatabaseManager.verifyConnectionLeaks(((JdbcBinaryCacheStore)this.cs).getConnectionFactory());
    }

    public void testPurgeExpiredAllCodepaths() throws Exception {
        FixedHashKey k1 = new FixedHashKey(1, "a");
        FixedHashKey k2 = new FixedHashKey(1, "b");
        this.cs.store(TestInternalCacheEntryFactory.create((Object)k1, (Object)"value"));
        this.cs.store(TestInternalCacheEntryFactory.create((Object)k2, (Object)"value", (long)1000L));
        for (int i = 0; i < 120; ++i) {
            this.cs.store(TestInternalCacheEntryFactory.create((Object)new FixedHashKey(i + 10, "non-exp k" + i), (Object)"value"));
            this.cs.store(TestInternalCacheEntryFactory.create((Object)new FixedHashKey(i + 10, "exp k" + i), (Object)"value", (long)1000L));
        }
        TestingUtil.sleepThread((long)1000L);
        assert (this.cs.containsKey((Object)k1));
        assert (!this.cs.containsKey((Object)k2));
        this.cs.purgeExpired();
        assert (this.cs.containsKey((Object)k1));
        assert (!this.cs.containsKey((Object)k2));
        UnitTestDatabaseManager.verifyConnectionLeaks(((JdbcBinaryCacheStore)this.cs).getConnectionFactory());
    }

    private static final class FixedHashKey
    implements Serializable {
        String s;
        int i;

        private FixedHashKey(int i, String s) {
            this.s = s;
            this.i = i;
        }

        public int hashCode() {
            return this.i;
        }

        public boolean equals(Object other) {
            return other instanceof FixedHashKey && this.s.equals(((FixedHashKey)other).s);
        }
    }
}

