/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.mixed;

import org.infinispan.Cache;
import org.infinispan.CacheImpl;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.jdbc.ManagedConnectionFactoryTest;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.connectionfactory.ManagedConnectionFactory;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStore;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStoreConfig;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.mixed.MixedStoreWithManagedConnectionTest")
public class MixedStoreWithManagedConnectionTest
extends ManagedConnectionFactoryTest {
    protected CacheStore createCacheStore() throws Exception {
        ConnectionFactoryConfig connectionFactoryConfig = new ConnectionFactoryConfig();
        connectionFactoryConfig.setConnectionFactoryClass(ManagedConnectionFactory.class.getName());
        connectionFactoryConfig.setDatasourceJndiLocation(this.getDatasourceLocation());
        TableManipulation stringsTm = UnitTestDatabaseManager.buildStringTableManipulation();
        stringsTm.setTableNamePrefix("STRINGS_TABLE");
        TableManipulation binaryTm = UnitTestDatabaseManager.buildBinaryTableManipulation();
        binaryTm.setTableNamePrefix("BINARY_TABLE");
        JdbcMixedCacheStoreConfig cacheStoreConfig = new JdbcMixedCacheStoreConfig(connectionFactoryConfig, binaryTm, stringsTm);
        cacheStoreConfig.setPurgeSynchronously(Boolean.valueOf(true));
        JdbcMixedCacheStore store = new JdbcMixedCacheStore();
        store.init((CacheLoaderConfig)cacheStoreConfig, (Cache)new CacheImpl("aName"), this.getMarshaller());
        store.start();
        assert (store.getConnectionFactory() instanceof ManagedConnectionFactory);
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoadFromFile() throws Exception {
        EmbeddedCacheManager cm = null;
        try {
            cm = TestCacheManagerFactory.fromXml((String)"configs/managed/mixed-managed-connection-factory.xml");
            Cache first = cm.getCache("first");
            Cache second = cm.getCache("second");
            CacheLoaderConfiguration firstCacheLoaderConfig = (CacheLoaderConfiguration)first.getCacheConfiguration().loaders().cacheLoaders().get(0);
            assert (firstCacheLoaderConfig != null);
            CacheLoaderConfiguration secondCacheLoaderConfig = (CacheLoaderConfiguration)second.getCacheConfiguration().loaders().cacheLoaders().get(0);
            assert (secondCacheLoaderConfig != null);
            assert (firstCacheLoaderConfig instanceof JdbcMixedCacheStoreConfiguration);
            assert (secondCacheLoaderConfig instanceof JdbcMixedCacheStoreConfiguration);
            CacheLoaderManager cacheLoaderManager = (CacheLoaderManager)first.getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class);
            JdbcMixedCacheStore loader = (JdbcMixedCacheStore)cacheLoaderManager.getCacheLoader();
            assert (loader.getConnectionFactory() instanceof ManagedConnectionFactory);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
            throw throwable;
        }
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
    }

    @Override
    public String getDatasourceLocation() {
        return "java:/MixedStoreWithManagedConnectionTest/DS";
    }
}

