/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.configuration.as;

import java.io.IOException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.jdbc.configuration.JdbcBinaryCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcStringBasedCacheStoreConfiguration;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.jdbc.configuration.as.XmlFileParsingTest")
public class XmlFileParsingTest
extends AbstractInfinispanTest {
    public void testStandaloneXml() throws IOException {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)"configs/as7/jdbc-standalone.xml", (boolean)true)){

            public void call() {
                Configuration c = this.cm.getCacheConfiguration("default");
                assert (c.clustering().cacheMode().equals((Object)CacheMode.DIST_SYNC));
                assert (c.locking().isolationLevel().equals((Object)IsolationLevel.READ_COMMITTED));
                assert (c.locking().lockAcquisitionTimeout() == 30000L);
                assert (c.locking().concurrencyLevel() == 1000);
                assert (!c.locking().useLockStriping());
                assert (c.transaction().transactionMode().equals((Object)TransactionMode.NON_TRANSACTIONAL));
                assert (c.eviction().strategy().equals((Object)EvictionStrategy.LRU));
                assert (c.eviction().maxEntries() == 1000);
                assert (!c.loaders().passivation());
                assert (!c.loaders().fetchPersistentState().booleanValue());
                assert (!c.loaders().shared());
                assert (c.loaders().cacheLoaders().size() == 1);
                JdbcMixedCacheStoreConfiguration jmcs = (JdbcMixedCacheStoreConfiguration)c.loaders().cacheLoaders().get(0);
                assert (jmcs.binaryTable().tableNamePrefix().equals("JDG_MIX_BKT"));
                assert (jmcs.binaryTable().idColumnName().equals("id"));
                assert (jmcs.binaryTable().idColumnType().equals("VARCHAR"));
                assert (jmcs.binaryTable().dataColumnName().equals("datum"));
                assert (jmcs.binaryTable().dataColumnType().equals("BINARY"));
                assert (jmcs.binaryTable().timestampColumnName().equals("version"));
                assert (jmcs.binaryTable().timestampColumnType().equals("BIGINT"));
                assert (jmcs.stringTable().tableNamePrefix().equals("JDG_MIX_STR"));
                assert (jmcs.stringTable().idColumnName().equals("id"));
                assert (jmcs.stringTable().idColumnType().equals("VARCHAR"));
                assert (jmcs.stringTable().dataColumnName().equals("datum"));
                assert (jmcs.stringTable().dataColumnType().equals("BINARY"));
                assert (jmcs.stringTable().timestampColumnName().equals("version"));
                assert (jmcs.stringTable().timestampColumnType().equals("BIGINT"));
                c = this.cm.getCacheConfiguration("stringCache");
                assert (c.clustering().cacheMode().equals((Object)CacheMode.DIST_SYNC));
                assert (c.loaders().passivation());
                assert (!c.loaders().fetchPersistentState().booleanValue());
                assert (!c.loaders().shared());
                assert (c.loaders().cacheLoaders().size() == 1);
                JdbcStringBasedCacheStoreConfiguration jscs = (JdbcStringBasedCacheStoreConfiguration)c.loaders().cacheLoaders().get(0);
                assert (jscs.table().tableNamePrefix().equals("JDG_MC_SK"));
                assert (jscs.table().idColumnName().equals("id"));
                assert (jscs.table().idColumnType().equals("VARCHAR"));
                assert (jscs.table().dataColumnName().equals("datum"));
                assert (jscs.table().dataColumnType().equals("BINARY"));
                assert (jscs.table().timestampColumnName().equals("version"));
                assert (jscs.table().timestampColumnType().equals("BIGINT"));
                assert (jscs.async().enabled());
                assert (jscs.async().flushLockTimeout() == 1L);
                assert (jscs.async().modificationQueueSize() == 1024);
                assert (jscs.async().shutdownTimeout() == 25000L);
                assert (jscs.async().threadPoolSize() == 1);
                c = this.cm.getCacheConfiguration("binaryCache");
                assert (c.clustering().cacheMode().equals((Object)CacheMode.DIST_SYNC));
                assert (!c.loaders().passivation());
                assert (!c.loaders().fetchPersistentState().booleanValue());
                assert (!c.loaders().shared());
                assert (c.loaders().cacheLoaders().size() == 1);
                JdbcBinaryCacheStoreConfiguration jbcs = (JdbcBinaryCacheStoreConfiguration)c.loaders().cacheLoaders().get(0);
                assert (jbcs.table().tableNamePrefix().equals("JDG_NC_BK"));
                assert (jbcs.table().idColumnName().equals("id"));
                assert (jbcs.table().idColumnType().equals("VARCHAR"));
                assert (jbcs.table().dataColumnName().equals("datum"));
                assert (jbcs.table().dataColumnType().equals("BINARY"));
                assert (jbcs.table().timestampColumnName().equals("version"));
                assert (jbcs.table().timestampColumnType().equals("BIGINT"));
            }
        });
    }
}

