/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.stringbased;

import org.infinispan.Cache;
import org.infinispan.CacheImpl;
import org.infinispan.loaders.BaseCacheStoreTest;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStore;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStoreConfig;
import org.infinispan.loaders.keymappers.UnsupportedKeyTypeException;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.mockito.Mockito;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.stringbased.JdbcStringBasedCacheStoreTest")
public class JdbcStringBasedCacheStoreTest
extends BaseCacheStoreTest {
    protected CacheStore createCacheStore() throws Exception {
        ConnectionFactoryConfig connectionFactoryConfig = UnitTestDatabaseManager.getUniqueConnectionFactoryConfig();
        TableManipulation tm = UnitTestDatabaseManager.buildStringTableManipulation();
        JdbcStringBasedCacheStoreConfig config = new JdbcStringBasedCacheStoreConfig(connectionFactoryConfig, tm);
        config.setPurgeSynchronously(Boolean.valueOf(true));
        JdbcStringBasedCacheStore stringBasedCacheStore = new JdbcStringBasedCacheStore();
        CacheImpl cache = new CacheImpl("aName");
        stringBasedCacheStore.init((CacheLoaderConfig)config, (Cache)cache, this.getMarshaller());
        stringBasedCacheStore.start();
        return stringBasedCacheStore;
    }

    public void testNotCreateConnectionFactory() throws Exception {
        JdbcStringBasedCacheStore stringBasedCacheStore = new JdbcStringBasedCacheStore();
        JdbcStringBasedCacheStoreConfig config = new JdbcStringBasedCacheStoreConfig(false);
        config.setCreateTableOnStart(false);
        stringBasedCacheStore.init((CacheLoaderConfig)config, (Cache)new CacheImpl("otherName"), this.getMarshaller());
        stringBasedCacheStore.start();
        assert (stringBasedCacheStore.getConnectionFactory() == null);
        ConnectionFactory connectionFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        TableManipulation tableManipulation = (TableManipulation)Mockito.mock(TableManipulation.class);
        config.setTableManipulation(tableManipulation);
        tableManipulation.start(connectionFactory);
        tableManipulation.setCacheName("otherName");
        stringBasedCacheStore.doConnectionFactoryInitialization(connectionFactory);
        Mockito.reset((Object[])new Object[]{tableManipulation, connectionFactory});
        tableManipulation.stop();
        stringBasedCacheStore.stop();
    }

    @Test(expectedExceptions={UnsupportedKeyTypeException.class})
    public void testLoadAndStoreMarshalledValues() throws CacheLoaderException {
        super.testLoadAndStoreMarshalledValues();
    }
}

