/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.stringbased;

import junit.framework.Assert;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.loaders.jdbc.stringbased.NonStringKeyPreloadTest;
import org.infinispan.loaders.jdbc.stringbased.Person;
import org.infinispan.loaders.jdbc.stringbased.TwoWayPersonKey2StringMapper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.stringbased.NonStringKeyStateTransferTest")
public class NonStringKeyStateTransferTest
extends AbstractCacheTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplicatedStateTransfer() {
        EmbeddedCacheManager cm1 = null;
        EmbeddedCacheManager cm2 = null;
        try {
            Configuration conf1 = NonStringKeyPreloadTest.createCacheStoreConfig(TwoWayPersonKey2StringMapper.class.getName(), false, true);
            conf1.setCacheMode(Configuration.CacheMode.REPL_SYNC);
            cm1 = TestCacheManagerFactory.createClusteredCacheManager((Configuration)conf1);
            Cache c1 = cm1.getCache();
            Person mircea = new Person("markus", "mircea", 30);
            Person mircea2 = new Person("markus2", "mircea2", 30);
            c1.put((Object)mircea, (Object)"mircea");
            c1.put((Object)mircea2, (Object)"mircea2");
            Configuration conf2 = NonStringKeyPreloadTest.createCacheStoreConfig(TwoWayPersonKey2StringMapper.class.getName(), false, true);
            conf2.setCacheMode(Configuration.CacheMode.REPL_SYNC);
            cm2 = TestCacheManagerFactory.createClusteredCacheManager((Configuration)conf2);
            Cache c2 = cm2.getCache();
            Assert.assertEquals((Object)"mircea", (Object)c2.get((Object)mircea));
            Assert.assertEquals((Object)"mircea2", (Object)c2.get((Object)mircea2));
            c2.get((Object)mircea2);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm1, cm2});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm1, cm2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedStateTransfer() {
        EmbeddedCacheManager cm1 = null;
        EmbeddedCacheManager cm2 = null;
        try {
            Configuration conf = NonStringKeyPreloadTest.createCacheStoreConfig(TwoWayPersonKey2StringMapper.class.getName(), false, false);
            conf.setCacheMode(Configuration.CacheMode.DIST_SYNC);
            cm1 = TestCacheManagerFactory.createClusteredCacheManager((Configuration)conf);
            Cache c1 = cm1.getCache();
            for (int i = 0; i < 100; ++i) {
                Person mircea = new Person("markus" + i, "mircea" + i, 30);
                c1.put((Object)mircea, (Object)("mircea" + i));
            }
            cm2 = TestCacheManagerFactory.createClusteredCacheManager((Configuration)conf);
            Cache c2 = cm2.getCache();
            assert (c2.size() > 0);
            for (Object key : c2.getAdvancedCache().getDataContainer().keySet()) {
                assert (key instanceof Person) : "expected key to be person but obtained " + key;
            }
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm1, cm2});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm1, cm2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedAndNoTwoWay() {
        Configuration conf = NonStringKeyPreloadTest.createCacheStoreConfig(TwoWayPersonKey2StringMapper.class.getName(), false, false);
        conf.setCacheMode(Configuration.CacheMode.DIST_SYNC);
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager((Configuration)conf);
        try {
            cm1.getCache();
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm1});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm1});
    }
}

