/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.mixed;

import org.infinispan.loaders.BaseCacheStoreTest;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStore;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStoreConfig;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.mixed.JdbcMixedCacheStore2Test")
public class JdbcMixedCacheStore2Test
extends BaseCacheStoreTest {
    protected CacheStore createCacheStore() throws Exception {
        JdbcMixedCacheStoreConfig jdbcCacheStoreConfig = new JdbcMixedCacheStoreConfig();
        TableManipulation stringsTm = UnitTestDatabaseManager.buildStringTableManipulation();
        stringsTm.setTableNamePrefix("STRINGS_TABLE");
        TableManipulation binaryTm = UnitTestDatabaseManager.buildBinaryTableManipulation();
        binaryTm.setTableNamePrefix("BINARY_TABLE");
        ConnectionFactoryConfig cfc = UnitTestDatabaseManager.getUniqueConnectionFactoryConfig();
        jdbcCacheStoreConfig.setConnectionFactoryConfig(cfc);
        jdbcCacheStoreConfig.setStringsTableManipulation(stringsTm);
        jdbcCacheStoreConfig.setBinaryTableManipulation(binaryTm);
        jdbcCacheStoreConfig.setPurgeSynchronously(Boolean.valueOf(true));
        JdbcMixedCacheStore cacheStore = new JdbcMixedCacheStore();
        cacheStore.init((CacheLoaderConfig)jdbcCacheStoreConfig, this.getCache(), this.getMarshaller());
        cacheStore.start();
        return cacheStore;
    }
}

