/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.stringbased;

import java.sql.Connection;
import junit.framework.Assert;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.connectionfactory.PooledConnectionFactory;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStoreConfig;
import org.infinispan.loaders.jdbc.stringbased.Person;
import org.infinispan.loaders.jdbc.stringbased.PersonKey2StringMapper;
import org.infinispan.loaders.jdbc.stringbased.TwoWayPersonKey2StringMapper;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.stringbased.NonStringKeyPreloadTest")
public class NonStringKeyPreloadTest
extends AbstractInfinispanTest {
    public void testPreloadWithKey2StringMapper() throws Exception {
        String mapperName = PersonKey2StringMapper.class.getName();
        Configuration cfg = NonStringKeyPreloadTest.createCacheStoreConfig(mapperName, false, true);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((Configuration)cfg)){

            public void call() {
                try {
                    this.cm.getCache();
                    assert (false) : " Preload with Key2StringMapper is not supported. Specify an TwoWayKey2StringMapper if you want to support it (or disable preload).";
                }
                catch (CacheException cacheException) {
                    // empty catch block
                }
            }
        });
    }

    public void testPreloadWithTwoWayKey2StringMapper() throws Exception {
        String mapperName = TwoWayPersonKey2StringMapper.class.getName();
        Configuration config = NonStringKeyPreloadTest.createCacheStoreConfig(mapperName, true, true);
        final Person mircea = new Person("Markus", "Mircea", 30);
        final Person dan = new Person("Dan", "Dude", 30);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((Configuration)config)){

            public void call() {
                Cache cache = this.cm.getCache();
                cache.put((Object)mircea, (Object)"me");
                cache.put((Object)dan, (Object)"mate");
            }
        });
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((Configuration)config)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                Cache cache = null;
                try {
                    cache = this.cm.getCache();
                    assert (cache.containsKey((Object)mircea));
                    assert (cache.containsKey((Object)dan));
                }
                finally {
                    TestingUtil.clearCacheLoader((Cache)cache);
                }
            }
        });
    }

    public void testPreloadWithTwoWayKey2StringMapperAndBoundedCache() throws Exception {
        String mapperName = TwoWayPersonKey2StringMapper.class.getName();
        Configuration config = NonStringKeyPreloadTest.createCacheStoreConfig(mapperName, true, true);
        config.setEvictionStrategy(EvictionStrategy.LRU);
        config.setEvictionMaxEntries(3);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((Configuration)config)){

            public void call() {
                AdvancedCache cache = this.cm.getCache().getAdvancedCache();
                for (int i = 0; i < 10; ++i) {
                    Person p = new Person("name" + i, "surname" + i, 30);
                    cache.put((Object)p, (Object)("" + i));
                }
            }
        });
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((Configuration)config)){

            public void call() {
                AdvancedCache cache = this.cm.getCache().getAdvancedCache();
                Assert.assertEquals((int)3, (int)cache.getDataContainer().size());
                int found = 0;
                for (int i = 0; i < 10; ++i) {
                    Person p = new Person("name" + i, "surname" + i, 30);
                    if (!cache.getDataContainer().containsKey((Object)p)) continue;
                    ++found;
                }
                Assert.assertEquals((int)3, (int)found);
            }
        });
    }

    static Configuration createCacheStoreConfig(String mapperName, boolean wrap, boolean preload) {
        ConnectionFactoryConfig connectionFactoryConfig = UnitTestDatabaseManager.getUniqueConnectionFactoryConfig();
        if (wrap) {
            connectionFactoryConfig.setConnectionFactoryClass(SharedConnectionFactory.class.getName());
        }
        TableManipulation tm = UnitTestDatabaseManager.buildStringTableManipulation();
        JdbcStringBasedCacheStoreConfig csConfig = new JdbcStringBasedCacheStoreConfig(connectionFactoryConfig, tm);
        csConfig.setFetchPersistentState(Boolean.valueOf(true));
        csConfig.setKey2StringMapperClass(mapperName);
        csConfig.getProperties().setProperty("key2StringMapperClass", mapperName);
        CacheLoaderManagerConfig cacheLoaders = new CacheLoaderManagerConfig();
        cacheLoaders.setPreload(Boolean.valueOf(preload));
        cacheLoaders.addCacheLoaderConfig((CacheLoaderConfig)csConfig);
        Configuration cfg = TestCacheManagerFactory.getDefaultConfiguration((boolean)false);
        cfg.setCacheLoaderManagerConfig(cacheLoaders);
        return cfg;
    }

    public static class SharedConnectionFactory
    extends ConnectionFactory {
        static PooledConnectionFactory sharedFactory;
        static boolean started;

        public void start(ConnectionFactoryConfig config, ClassLoader classLoader) throws CacheLoaderException {
            if (!started) {
                sharedFactory = new PooledConnectionFactory();
                sharedFactory.start(config, classLoader);
                started = true;
            }
        }

        public void stop() {
        }

        public Connection getConnection() throws CacheLoaderException {
            return sharedFactory.getConnection();
        }

        public void releaseConnection(Connection conn) {
            sharedFactory.releaseConnection(conn);
        }

        static {
            started = false;
        }
    }
}

