/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.configuration;

import java.lang.reflect.Constructor;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.ConfigurationUtils;
import org.infinispan.configuration.cache.AbstractLockSupportStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.AbstractJdbcCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.loaders.jdbc.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.JdbcCacheStoreConfigurationChildBuilder;
import org.infinispan.loaders.jdbc.configuration.ManagedConnectionFactoryConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.SimpleConnectionFactoryConfigurationBuilder;

public abstract class AbstractJdbcCacheStoreConfigurationBuilder<T extends AbstractJdbcCacheStoreConfiguration, S extends AbstractJdbcCacheStoreConfigurationBuilder<T, S>>
extends AbstractLockSupportStoreConfigurationBuilder<T, S>
implements JdbcCacheStoreConfigurationChildBuilder<S> {
    protected ConnectionFactoryConfigurationBuilder<ConnectionFactoryConfiguration> connectionFactory;

    public AbstractJdbcCacheStoreConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public PooledConnectionFactoryConfigurationBuilder<S> connectionPool() {
        return this.connectionFactory(PooledConnectionFactoryConfigurationBuilder.class);
    }

    @Override
    public ManagedConnectionFactoryConfigurationBuilder<S> dataSource() {
        return this.connectionFactory(ManagedConnectionFactoryConfigurationBuilder.class);
    }

    @Override
    public SimpleConnectionFactoryConfigurationBuilder<S> simpleConnection() {
        return this.connectionFactory(SimpleConnectionFactoryConfigurationBuilder.class);
    }

    public <C extends ConnectionFactoryConfigurationBuilder<?>> C connectionFactory(Class<C> klass) {
        if (this.connectionFactory != null) {
            throw new IllegalStateException("A ConnectionFactory has already been configured for this store");
        }
        try {
            ConnectionFactoryConfigurationBuilder builder;
            Constructor<C> constructor = klass.getDeclaredConstructor(AbstractJdbcCacheStoreConfigurationBuilder.class);
            this.connectionFactory = builder = (ConnectionFactoryConfigurationBuilder)constructor.newInstance(this);
            return (C)builder;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Could not instantiate loader configuration builder '" + klass.getName() + "'", (Throwable)e);
        }
    }

    public void validate() {
        super.validate();
        if (this.connectionFactory == null) {
            throw new CacheConfigurationException("A ConnectionFactory has not been specified for the Store");
        }
    }

    protected S readInternal(AbstractJdbcCacheStoreConfiguration template) {
        Class cfb = ConfigurationUtils.builderFor((Object)template.connectionFactory());
        this.connectionFactory(cfb);
        this.connectionFactory.read(template.connectionFactory());
        this.lockAcquistionTimeout = template.lockAcquistionTimeout();
        this.lockConcurrencyLevel = template.lockConcurrencyLevel();
        this.fetchPersistentState = template.fetchPersistentState();
        this.ignoreModifications = template.ignoreModifications();
        this.properties = template.properties();
        this.purgeOnStartup = template.purgeOnStartup();
        this.purgeSynchronously = template.purgeSynchronously();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        return (S)((AbstractJdbcCacheStoreConfigurationBuilder)this.self());
    }
}

