/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.binary;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.loaders.jdbc.ManagedConnectionFactoryTest;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStore;
import org.infinispan.loaders.jdbc.configuration.JdbcBinaryCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcBinaryCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.connectionfactory.ManagedConnectionFactory;
import org.infinispan.loaders.manager.CacheLoaderManager;
import org.infinispan.loaders.spi.CacheStore;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.binary.BinaryStoreWithManagedConnectionTest")
public class BinaryStoreWithManagedConnectionTest
extends ManagedConnectionFactoryTest {
    protected CacheStore createCacheStore() throws Exception {
        JdbcBinaryCacheStoreConfigurationBuilder storeBuilder = (JdbcBinaryCacheStoreConfigurationBuilder)((JdbcBinaryCacheStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).loaders().addLoader(JdbcBinaryCacheStoreConfigurationBuilder.class)).purgeSynchronously(true);
        storeBuilder.dataSource().jndiUrl(this.getDatasourceLocation());
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table(), true);
        JdbcBinaryCacheStore jdbcBinaryCacheStore = new JdbcBinaryCacheStore();
        jdbcBinaryCacheStore.init((CacheLoaderConfiguration)storeBuilder.create(), this.getCache(), this.getMarshaller());
        jdbcBinaryCacheStore.start();
        assert (jdbcBinaryCacheStore.getConnectionFactory() instanceof ManagedConnectionFactory);
        return jdbcBinaryCacheStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoadFromFile() throws Exception {
        EmbeddedCacheManager cm;
        block10: {
            cm = null;
            try {
                cm = TestCacheManagerFactory.fromXml((String)"configs/managed/binary-managed-connection-factory.xml");
                Cache first = cm.getCache("first");
                Cache second = cm.getCache("second");
                CacheLoaderConfiguration firstCacheLoaderConfig = (CacheLoaderConfiguration)first.getCacheConfiguration().loaders().cacheLoaders().get(0);
                assert (firstCacheLoaderConfig != null);
                CacheLoaderConfiguration secondCacheLoaderConfig = (CacheLoaderConfiguration)second.getCacheConfiguration().loaders().cacheLoaders().get(0);
                assert (secondCacheLoaderConfig != null);
                assert (firstCacheLoaderConfig instanceof JdbcBinaryCacheStoreConfiguration);
                assert (secondCacheLoaderConfig instanceof JdbcBinaryCacheStoreConfiguration);
                CacheLoaderManager cacheLoaderManager = (CacheLoaderManager)first.getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class);
                JdbcBinaryCacheStore loader = (JdbcBinaryCacheStore)cacheLoaderManager.getCacheLoader();
                if ($assertionsDisabled || loader.getConnectionFactory() instanceof ManagedConnectionFactory) break block10;
                throw new AssertionError();
            }
            catch (Throwable throwable) {
                try {
                    TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getDatasourceLocation() {
        return "java:/BinaryStoreWithManagedConnectionTest/DS";
    }
}

