/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.mixed;

import junit.framework.Assert;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedCacheStoreConfigurationBuilder;
import org.infinispan.loaders.keymappers.DefaultTwoWayKey2StringMapper;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.jdbc.mixed.JdbcMixedCacheStoreConfigurationTest")
public class JdbcMixedCacheStoreConfigurationTest {
    private JdbcMixedCacheStoreConfiguration config;
    private JdbcMixedCacheStoreConfigurationBuilder storeBuilder;

    @BeforeMethod
    public void setUp() {
        this.storeBuilder = (JdbcMixedCacheStoreConfigurationBuilder)((JdbcMixedCacheStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).loaders().addLoader(JdbcMixedCacheStoreConfigurationBuilder.class)).purgeSynchronously(true);
        this.storeBuilder.simpleConnection().connectionUrl("url").driverClass("driver");
    }

    public void simpleTest() {
        ((JdbcMixedCacheStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedCacheStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedCacheStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedCacheStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedCacheStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedCacheStoreConfigurationBuilder)this.storeBuilder.purgeSynchronously(true)).binaryTable().createOnStart(false)).dataColumnName("binary_dc")).dataColumnType("binary_dct")).stringTable().createOnStart(true)).dataColumnName("strings_dc")).dataColumnType("strings_dct");
        this.config = this.storeBuilder.create();
        Assert.assertFalse((boolean)this.config.binaryTable().createOnStart());
        Assert.assertTrue((boolean)this.config.stringTable().createOnStart());
        Assert.assertEquals((String)this.config.binaryTable().dataColumnName(), (String)"binary_dc");
        Assert.assertEquals((String)this.config.binaryTable().dataColumnType(), (String)"binary_dct");
        Assert.assertEquals((String)this.config.stringTable().dataColumnName(), (String)"strings_dc");
        Assert.assertEquals((String)this.config.stringTable().dataColumnType(), (String)"strings_dct");
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testSameTableName() {
        ((JdbcMixedCacheStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)this.storeBuilder.binaryTable().tableNamePrefix("failTable")).stringTable().tableNamePrefix("failTable");
        this.storeBuilder.validate();
    }

    public void testKey2StringMapper() {
        this.storeBuilder.key2StringMapper(DefaultTwoWayKey2StringMapper.class.getName());
        this.config = this.storeBuilder.create();
        Assert.assertEquals((String)this.config.key2StringMapper(), (String)DefaultTwoWayKey2StringMapper.class.getName());
    }

    public void testConcurrencyLevel() {
        this.config = this.storeBuilder.create();
        Assert.assertEquals((int)2048, (int)this.config.lockConcurrencyLevel());
        JdbcMixedCacheStoreConfigurationBuilder storeBuilder2 = (JdbcMixedCacheStoreConfigurationBuilder)((JdbcMixedCacheStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).loaders().addLoader(JdbcMixedCacheStoreConfigurationBuilder.class)).read(this.config).lockConcurrencyLevel(12);
        this.config = storeBuilder2.create();
        Assert.assertEquals((int)12, (int)this.config.lockConcurrencyLevel());
    }

    public void testEnforcedSyncPurging() {
        this.config = this.storeBuilder.create();
        Assert.assertTrue((boolean)this.config.purgeSynchronously());
    }

    public void voidTestLockAcquisitionTimeout() {
        this.config = this.storeBuilder.create();
        Assert.assertEquals((long)60000L, (long)this.config.lockAcquistionTimeout());
        JdbcMixedCacheStoreConfigurationBuilder storeBuilder2 = (JdbcMixedCacheStoreConfigurationBuilder)((JdbcMixedCacheStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).loaders().addLoader(JdbcMixedCacheStoreConfigurationBuilder.class)).read(this.config).lockConcurrencyLevel(13);
        this.config = storeBuilder2.create();
        Assert.assertEquals((int)13, (int)this.config.lockConcurrencyLevel());
    }
}

