/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.mixed;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Set;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.io.UnclosableObjectInputStream;
import org.infinispan.io.UnclosableObjectOutputStream;
import org.infinispan.loaders.AbstractCacheStoreTest;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.TableName;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStore;
import org.infinispan.loaders.jdbc.stringbased.Person;
import org.infinispan.loaders.keymappers.DefaultTwoWayKey2StringMapper;
import org.infinispan.loaders.spi.CacheStore;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.mixed.JdbcMixedCacheStoreTest")
public class JdbcMixedCacheStoreTest {
    private CacheStore cacheStore;
    private TableManipulation stringsTm;
    private TableManipulation binaryTm;
    private ConnectionFactoryConfig cfc;
    private static final Person MIRCEA = new Person("Mircea", "Markus", 28);
    private static final Person MANIK = new Person("Manik", "Surtani", 18);

    @BeforeMethod
    public void createCacheStore() throws CacheLoaderException {
        JdbcMixedCacheStoreConfigurationBuilder storeBuilder = (JdbcMixedCacheStoreConfigurationBuilder)((JdbcMixedCacheStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).loaders().addLoader(JdbcMixedCacheStoreConfigurationBuilder.class)).purgeSynchronously(true);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.stringTable(), false);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.binaryTable(), true);
        ((JdbcMixedCacheStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)storeBuilder.stringTable().tableNamePrefix("STRINGS_TABLE")).key2StringMapper(DefaultTwoWayKey2StringMapper.class).binaryTable().tableNamePrefix("BINARY_TABLE");
        UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder);
        JdbcMixedCacheStoreConfiguration storeConfiguration = storeBuilder.create();
        this.cacheStore = new JdbcMixedCacheStore();
        this.cacheStore.init((CacheLoaderConfiguration)storeConfiguration, AbstractCacheStoreTest.mockCache((String)this.getClass().getName()), this.getMarshaller());
        this.cacheStore.start();
        this.stringsTm = (TableManipulation)ReflectionUtil.getValue((Object)((JdbcMixedCacheStore)this.cacheStore).getStringBasedCacheStore(), (String)"tableManipulation");
        this.binaryTm = (TableManipulation)ReflectionUtil.getValue((Object)((JdbcMixedCacheStore)this.cacheStore).getBinaryCacheStore(), (String)"tableManipulation");
    }

    @AfterMethod
    public void destroyStore() throws Exception {
        this.cacheStore.clear();
        this.assertBinaryRowCount(0);
        this.assertStringsRowCount(0);
        this.cacheStore.stop();
    }

    public void testMixedStore() throws Exception {
        this.cacheStore.store(TestInternalCacheEntryFactory.create((Object)"String", (Object)"someValue"));
        this.assertStringsRowCount(1);
        this.assertBinaryRowCount(0);
        this.cacheStore.store(TestInternalCacheEntryFactory.create((Object)MIRCEA, (Object)"value"));
        this.assertStringsRowCount(1);
        this.assertStringsRowCount(1);
        assert (this.cacheStore.load((Object)MIRCEA).getValue().equals("value"));
        assert (this.cacheStore.load((Object)"String").getValue().equals("someValue"));
    }

    public void testMultipleEntriesWithSameHashCode() throws Exception {
        Person one = new Person("Mircea", "Markus", 28);
        Person two = new Person("Manik", "Surtani", 28);
        one.setHashCode(100);
        two.setHashCode(100);
        this.cacheStore.store(TestInternalCacheEntryFactory.create((Object)one, (Object)"value"));
        this.assertBinaryRowCount(1);
        this.assertStringsRowCount(0);
        this.cacheStore.store(TestInternalCacheEntryFactory.create((Object)two, (Object)"otherValue"));
        this.assertBinaryRowCount(1);
        this.assertStringsRowCount(0);
        assert (this.cacheStore.load((Object)one).getValue().equals("value"));
        assert (this.cacheStore.load((Object)two).getValue().equals("otherValue"));
    }

    public void testClear() throws Exception {
        this.cacheStore.store(TestInternalCacheEntryFactory.create((Object)"String", (Object)"someValue"));
        this.assertRowCounts(0, 1);
        this.cacheStore.store(TestInternalCacheEntryFactory.create((Object)MIRCEA, (Object)"value"));
        this.assertRowCounts(1, 1);
        this.cacheStore.clear();
        this.assertRowCounts(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMixedFromAndToStream() throws Exception {
        this.cacheStore.store(TestInternalCacheEntryFactory.create((Object)"String", (Object)"someValue"));
        this.cacheStore.store(TestInternalCacheEntryFactory.create((Object)"String2", (Object)"someValue"));
        this.cacheStore.store(TestInternalCacheEntryFactory.create((Object)MIRCEA, (Object)"value1"));
        this.cacheStore.store(TestInternalCacheEntryFactory.create((Object)MANIK, (Object)"value2"));
        this.assertRowCounts(2, 2);
        StreamingMarshaller marshaller = this.getMarshaller();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutput oo = marshaller.startObjectOutput((OutputStream)out, false, 12);
        try {
            this.cacheStore.toStream((ObjectOutput)new UnclosableObjectOutputStream(oo));
        }
        finally {
            marshaller.finishObjectOutput(oo);
            out.close();
            this.cacheStore.clear();
        }
        this.assertRowCounts(0, 0);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ObjectInput oi = marshaller.startObjectInput((InputStream)in, false);
        try {
            this.cacheStore.fromStream((ObjectInput)new UnclosableObjectInputStream(oi));
        }
        finally {
            marshaller.finishObjectInput(oi);
            in.close();
        }
        this.assertRowCounts(2, 2);
        assert (this.cacheStore.load((Object)"String").getValue().equals("someValue"));
        assert (this.cacheStore.load((Object)"String2").getValue().equals("someValue"));
        assert (this.cacheStore.load((Object)MIRCEA).getValue().equals("value1"));
        assert (this.cacheStore.load((Object)MANIK).getValue().equals("value2"));
    }

    public void testLoadAll() throws Exception {
        InternalCacheEntry first = TestInternalCacheEntryFactory.create((Object)"String", (Object)"someValue");
        InternalCacheEntry second = TestInternalCacheEntryFactory.create((Object)"String2", (Object)"someValue");
        InternalCacheEntry third = TestInternalCacheEntryFactory.create((Object)MIRCEA, (Object)"value1");
        InternalCacheEntry forth = TestInternalCacheEntryFactory.create((Object)MANIK, (Object)"value2");
        this.cacheStore.store(first);
        this.cacheStore.store(second);
        this.cacheStore.store(third);
        this.cacheStore.store(forth);
        this.assertRowCounts(2, 2);
        Set entries = this.cacheStore.loadAll();
        assert (entries.size() == 4) : "Expected 4 and got: " + entries;
        assert (entries.contains(first));
        assert (entries.contains(second));
        assert (entries.contains(third));
        assert (entries.contains(forth));
    }

    public void testPurgeExpired() throws Exception {
        InternalCacheEntry first = TestInternalCacheEntryFactory.create((Object)"String", (Object)"someValue", (long)1000L);
        InternalCacheEntry second = TestInternalCacheEntryFactory.create((Object)MIRCEA, (Object)"value1", (long)1000L);
        this.cacheStore.store(first);
        this.cacheStore.store(second);
        this.assertRowCounts(1, 1);
        Thread.sleep(1200L);
        this.cacheStore.purgeExpired();
        this.assertRowCounts(0, 0);
    }

    public void testPurgeExpiredWithRemainingEntries() throws Exception {
        InternalCacheEntry first = TestInternalCacheEntryFactory.create((Object)"String", (Object)"someValue", (long)1000L);
        InternalCacheEntry second = TestInternalCacheEntryFactory.create((Object)"String2", (Object)"someValue");
        InternalCacheEntry third = TestInternalCacheEntryFactory.create((Object)MIRCEA, (Object)"value1", (long)1000L);
        InternalCacheEntry forth = TestInternalCacheEntryFactory.create((Object)MANIK, (Object)"value1");
        this.cacheStore.store(first);
        this.cacheStore.store(second);
        this.cacheStore.store(third);
        this.cacheStore.store(forth);
        this.assertRowCounts(2, 2);
        Thread.sleep(1200L);
        this.cacheStore.purgeExpired();
        this.assertRowCounts(1, 1);
    }

    private void assertRowCounts(int binary, int strings) {
        this.assertBinaryRowCount(binary);
        this.assertStringsRowCount(strings);
    }

    private void assertStringsRowCount(int rowCount) {
        JdbcMixedCacheStore store = (JdbcMixedCacheStore)this.cacheStore;
        ConnectionFactory connectionFactory = store.getConnectionFactory();
        TableName tableName = this.stringsTm.getTableName();
        int value = UnitTestDatabaseManager.rowCount(connectionFactory, tableName);
        assert (value == rowCount) : "Expected " + rowCount + " rows, actual value is " + value;
    }

    private void assertBinaryRowCount(int rowCount) {
        JdbcMixedCacheStore store = (JdbcMixedCacheStore)this.cacheStore;
        ConnectionFactory connectionFactory = store.getConnectionFactory();
        TableName tableName = this.binaryTm.getTableName();
        int value = UnitTestDatabaseManager.rowCount(connectionFactory, tableName);
        assert (value == rowCount) : "Expected " + rowCount + " rows, actual value is " + value;
    }

    protected StreamingMarshaller getMarshaller() {
        return new TestObjectStreamMarshaller(false);
    }
}

