/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.mixed;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.loaders.jdbc.ManagedConnectionFactoryTest;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.connectionfactory.ManagedConnectionFactory;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStore;
import org.infinispan.loaders.manager.CacheLoaderManager;
import org.infinispan.loaders.spi.CacheStore;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.mixed.MixedStoreWithManagedConnectionTest")
public class MixedStoreWithManagedConnectionTest
extends ManagedConnectionFactoryTest {
    protected CacheStore createCacheStore() throws Exception {
        JdbcMixedCacheStoreConfigurationBuilder storeBuilder = (JdbcMixedCacheStoreConfigurationBuilder)((JdbcMixedCacheStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).loaders().addLoader(JdbcMixedCacheStoreConfigurationBuilder.class)).purgeSynchronously(true);
        storeBuilder.dataSource().jndiUrl(this.getDatasourceLocation());
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.stringTable(), false);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.binaryTable(), true);
        ((JdbcMixedCacheStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)storeBuilder.binaryTable().tableNamePrefix("BINARY_TABLE")).stringTable().tableNamePrefix("STRINGS_TABLE");
        JdbcMixedCacheStore store = new JdbcMixedCacheStore();
        store.init((CacheLoaderConfiguration)storeBuilder.create(), this.getCache(), this.getMarshaller());
        store.start();
        assert (store.getConnectionFactory() instanceof ManagedConnectionFactory);
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoadFromFile() throws Exception {
        EmbeddedCacheManager cm = null;
        try {
            cm = TestCacheManagerFactory.fromXml((String)"configs/managed/mixed-managed-connection-factory.xml");
            Cache first = cm.getCache("first");
            Cache second = cm.getCache("second");
            CacheLoaderConfiguration firstCacheLoaderConfig = (CacheLoaderConfiguration)first.getCacheConfiguration().loaders().cacheLoaders().get(0);
            assert (firstCacheLoaderConfig != null);
            CacheLoaderConfiguration secondCacheLoaderConfig = (CacheLoaderConfiguration)second.getCacheConfiguration().loaders().cacheLoaders().get(0);
            assert (secondCacheLoaderConfig != null);
            assert (firstCacheLoaderConfig instanceof JdbcMixedCacheStoreConfiguration);
            assert (secondCacheLoaderConfig instanceof JdbcMixedCacheStoreConfiguration);
            CacheLoaderManager cacheLoaderManager = (CacheLoaderManager)first.getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class);
            JdbcMixedCacheStore loader = (JdbcMixedCacheStore)cacheLoaderManager.getCacheLoader();
            assert (loader.getConnectionFactory() instanceof ManagedConnectionFactory);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
            throw throwable;
        }
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
    }

    @Override
    public String getDatasourceLocation() {
        return "java:/MixedStoreWithManagedConnectionTest/DS";
    }
}

