/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.stringbased;

import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.loaders.BaseCacheStoreTest;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.configuration.JdbcStringBasedCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStore;
import org.infinispan.loaders.keymappers.UnsupportedKeyTypeException;
import org.infinispan.loaders.spi.CacheStore;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.mockito.Mockito;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.stringbased.JdbcStringBasedCacheStoreTest")
public class JdbcStringBasedCacheStoreTest
extends BaseCacheStoreTest {
    protected CacheStore createCacheStore() throws Exception {
        JdbcStringBasedCacheStoreConfigurationBuilder storeBuilder = (JdbcStringBasedCacheStoreConfigurationBuilder)((JdbcStringBasedCacheStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).loaders().addLoader(JdbcStringBasedCacheStoreConfigurationBuilder.class)).purgeSynchronously(true);
        UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table(), false);
        JdbcStringBasedCacheStore stringBasedCacheStore = new JdbcStringBasedCacheStore();
        stringBasedCacheStore.init((CacheLoaderConfiguration)storeBuilder.create(), this.getCache(), this.getMarshaller());
        stringBasedCacheStore.start();
        return stringBasedCacheStore;
    }

    public void testNotCreateConnectionFactory() throws Exception {
        JdbcStringBasedCacheStoreConfigurationBuilder storeBuilder = (JdbcStringBasedCacheStoreConfigurationBuilder)((JdbcStringBasedCacheStoreConfigurationBuilder)((JdbcStringBasedCacheStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).loaders().addLoader(JdbcStringBasedCacheStoreConfigurationBuilder.class)).purgeSynchronously(true)).manageConnectionFactory(false);
        storeBuilder.table().createOnStart(false);
        JdbcStringBasedCacheStore stringBasedCacheStore = new JdbcStringBasedCacheStore();
        stringBasedCacheStore.init((CacheLoaderConfiguration)storeBuilder.create(), this.getCache(), this.getMarshaller());
        stringBasedCacheStore.start();
        assert (stringBasedCacheStore.getConnectionFactory() == null);
        ConnectionFactory connectionFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        TableManipulation tableManipulation = (TableManipulation)Mockito.mock(TableManipulation.class);
        tableManipulation.start(connectionFactory);
        tableManipulation.setCacheName("otherName");
        stringBasedCacheStore.doConnectionFactoryInitialization(connectionFactory);
        Mockito.reset((Object[])new Object[]{tableManipulation, connectionFactory});
        tableManipulation.stop();
        stringBasedCacheStore.stop();
    }

    @Test(expectedExceptions={UnsupportedKeyTypeException.class})
    public void testLoadAndStoreMarshalledValues() throws CacheLoaderException {
        super.testLoadAndStoreMarshalledValues();
    }
}

