/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.stringbased;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.jdbc.ManagedConnectionFactoryTest;
import org.infinispan.loaders.jdbc.configuration.JdbcStringBasedCacheStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcStringBasedCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.connectionfactory.ManagedConnectionFactory;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStore;
import org.infinispan.loaders.keymappers.UnsupportedKeyTypeException;
import org.infinispan.loaders.manager.CacheLoaderManager;
import org.infinispan.loaders.spi.CacheStore;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.stringbased.StringStoreWithManagedConnectionTest")
public class StringStoreWithManagedConnectionTest
extends ManagedConnectionFactoryTest {
    protected CacheStore createCacheStore() throws Exception {
        JdbcStringBasedCacheStoreConfigurationBuilder storeBuilder = (JdbcStringBasedCacheStoreConfigurationBuilder)((JdbcStringBasedCacheStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).loaders().addLoader(JdbcStringBasedCacheStoreConfigurationBuilder.class)).purgeSynchronously(true);
        storeBuilder.dataSource().jndiUrl(this.getDatasourceLocation());
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table(), false);
        JdbcStringBasedCacheStore stringBasedCacheStore = new JdbcStringBasedCacheStore();
        stringBasedCacheStore.init((CacheLoaderConfiguration)storeBuilder.create(), this.getCache(), this.getMarshaller());
        stringBasedCacheStore.start();
        return stringBasedCacheStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoadFromFile() throws Exception {
        EmbeddedCacheManager cm = null;
        try {
            cm = TestCacheManagerFactory.fromXml((String)"configs/managed/str-managed-connection-factory.xml");
            Cache first = cm.getCache("first");
            Cache second = cm.getCache("second");
            CacheLoaderConfiguration firstCacheLoaderConfig = (CacheLoaderConfiguration)first.getCacheConfiguration().loaders().cacheLoaders().get(0);
            assert (firstCacheLoaderConfig != null);
            CacheLoaderConfiguration secondCacheLoaderConfig = (CacheLoaderConfiguration)second.getCacheConfiguration().loaders().cacheLoaders().get(0);
            assert (secondCacheLoaderConfig != null);
            assert (firstCacheLoaderConfig instanceof JdbcStringBasedCacheStoreConfiguration);
            assert (secondCacheLoaderConfig instanceof JdbcStringBasedCacheStoreConfiguration);
            CacheLoaderManager cacheLoaderManager = (CacheLoaderManager)first.getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class);
            JdbcStringBasedCacheStore loader = (JdbcStringBasedCacheStore)cacheLoaderManager.getCacheLoader();
            assert (loader.getConnectionFactory() instanceof ManagedConnectionFactory);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
            throw throwable;
        }
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
    }

    @Override
    public String getDatasourceLocation() {
        return "java:/StringStoreWithManagedConnectionTest/DS";
    }

    @Test(expectedExceptions={UnsupportedKeyTypeException.class})
    public void testLoadAndStoreMarshalledValues() throws CacheLoaderException {
        super.testLoadAndStoreMarshalledValues();
    }
}

