/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.jdbc.JdbcUtil;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.logging.Log;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.LogFactory;

public abstract class DataManipulationHelper {
    private static final Log log = (Log)LogFactory.getLog(DataManipulationHelper.class, Log.class);
    private final ConnectionFactory connectionFactory;
    private final TableManipulation tableManipulation;
    protected StreamingMarshaller marshaller;
    private final TimeService timeService;

    public DataManipulationHelper(ConnectionFactory connectionFactory, TableManipulation tableManipulation, StreamingMarshaller marshaller, TimeService timeService) {
        this.connectionFactory = connectionFactory;
        this.tableManipulation = tableManipulation;
        this.marshaller = marshaller;
        this.timeService = timeService;
    }

    public void clear() throws CacheLoaderException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String sql = this.tableManipulation.getDeleteAllRowsSql();
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            int result = ps.executeUpdate();
            if (log.isTraceEnabled()) {
                log.tracef("Successfully removed %d rows.", result);
            }
        }
        catch (SQLException ex) {
            try {
                log.failedClearingJdbcCacheStore(ex);
                throw new CacheLoaderException("Failed clearing cache store", (Throwable)ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void fromStreamSupport(ObjectInput objectInput) throws CacheLoaderException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.connectionFactory.getConnection();
            String sql = this.tableManipulation.getInsertRowSql();
            ps = conn.prepareStatement(sql);
            int readCount = 0;
            int batchSize = this.tableManipulation.getBatchSize();
            Object objFromStream = this.marshaller.objectFromObjectStream(objectInput);
            while (this.fromStreamProcess(objFromStream, ps, objectInput)) {
                ps.addBatch();
                if (++readCount % batchSize == 0) {
                    ps.executeBatch();
                    if (log.isTraceEnabled()) {
                        log.tracef("Executing batch %s, batch size is %d", readCount / batchSize, batchSize);
                    }
                }
                objFromStream = this.marshaller.objectFromObjectStream(objectInput);
            }
            if (readCount % batchSize != 0) {
                ps.executeBatch();
            }
            if (log.isTraceEnabled()) {
                log.tracef("Successfully inserted %d buckets into the database, batch size is %d", readCount, batchSize);
            }
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
            return;
        }
        catch (IOException ex) {
            log.ioErrorIntegratingState(ex);
            throw new CacheLoaderException("I/O failure while integrating state into store", (Throwable)ex);
            catch (SQLException e) {
                log.sqlFailureIntegratingState(e);
                throw new CacheLoaderException("SQL failure while integrating state into store", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.classNotFoundIntegratingState(e);
                throw new CacheLoaderException("Unexpected failure while integrating state into store", (Throwable)e);
            }
            catch (InterruptedException ie) {
                if (log.isTraceEnabled()) {
                    log.trace("Interrupted while reading from stream");
                }
                Thread.currentThread().interrupt();
                return;
            }
        }
        finally {
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void toStreamSupport(ObjectOutput objectOutput, byte streamDelimiter, boolean filterExpired) throws CacheLoaderException {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql;
            String string = sql = filterExpired ? this.tableManipulation.getLoadNonExpiredAllRowsSql() : this.tableManipulation.getLoadAllRowsSql();
            if (log.isTraceEnabled()) {
                log.tracef("Running sql %s", sql);
            }
            connection = this.connectionFactory.getConnection();
            ps = connection.prepareStatement(sql);
            if (filterExpired) {
                ps.setLong(1, this.timeService.wallClockTime());
            }
            rs = ps.executeQuery();
            rs.setFetchSize(this.tableManipulation.getFetchSize());
            while (rs.next()) {
                InputStream is = rs.getBinaryStream(1);
                this.toStreamProcess(rs, is, objectOutput);
            }
            this.marshaller.objectToObjectStream((Object)streamDelimiter, objectOutput);
        }
        catch (SQLException e) {
            try {
                log.sqlFailureStoringKeys(e);
                throw new CacheLoaderException("SQL Error while storing string keys to database", (Throwable)e);
                catch (IOException e2) {
                    log.ioErrorStoringKeys(e2);
                    throw new CacheLoaderException("I/O Error while storing string keys to database", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(connection);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(connection);
    }

    public final Set<InternalCacheEntry> loadAllSupport(boolean filterExpired) throws CacheLoaderException {
        HashSet<InternalCacheEntry> hashSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql;
            String string = sql = filterExpired ? this.tableManipulation.getLoadNonExpiredAllRowsSql() : this.tableManipulation.getLoadAllRowsSql();
            if (log.isTraceEnabled()) {
                log.tracef("Running sql %s", sql);
            }
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            if (filterExpired) {
                ps.setLong(1, this.timeService.wallClockTime());
            }
            rs = ps.executeQuery();
            rs.setFetchSize(this.tableManipulation.getFetchSize());
            HashSet<InternalCacheEntry> result = new HashSet<InternalCacheEntry>(this.tableManipulation.getFetchSize());
            while (rs.next()) {
                this.loadAllProcess(rs, result);
            }
            hashSet = result;
        }
        catch (SQLException e) {
            try {
                log.sqlFailureFetchingAllStoredEntries(e);
                throw new CacheLoaderException("SQL error while fetching all StoredEntries", (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        return hashSet;
    }

    public Set<Object> loadAllKeysSupport(Set<Object> keysToExclude) throws CacheLoaderException {
        HashSet<Object> hashSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = this.getLoadAllKeysSql();
            if (log.isTraceEnabled()) {
                log.trace("Running sql '" + sql);
            }
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            rs.setFetchSize(this.tableManipulation.getFetchSize());
            HashSet<Object> result = new HashSet<Object>(this.tableManipulation.getFetchSize());
            while (rs.next()) {
                this.loadAllKeysProcess(rs, result, keysToExclude);
            }
            hashSet = result;
        }
        catch (SQLException e) {
            try {
                log.sqlFailureFetchingAllStoredEntries(e);
                throw new CacheLoaderException("SQL error while fetching all StoredEntries", (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        return hashSet;
    }

    public final Set<InternalCacheEntry> loadSome(int maxEntries) throws CacheLoaderException {
        HashSet<InternalCacheEntry> hashSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = this.tableManipulation.getLoadSomeRowsSql();
            if (log.isTraceEnabled()) {
                log.trace("Running sql '" + sql);
            }
            conn = this.connectionFactory.getConnection();
            if (this.tableManipulation.isVariableLimitSupported()) {
                ps = conn.prepareStatement(sql);
                ps.setInt(1, maxEntries);
            } else {
                ps = conn.prepareStatement(sql.replace("?", String.valueOf(maxEntries)));
            }
            rs = ps.executeQuery();
            rs.setFetchSize(this.tableManipulation.getFetchSize());
            HashSet<InternalCacheEntry> result = new HashSet<InternalCacheEntry>(maxEntries);
            while (rs.next()) {
                this.loadAllProcess(rs, result, maxEntries);
            }
            hashSet = result;
        }
        catch (SQLException e) {
            try {
                log.sqlFailureFetchingAllStoredEntries(e);
                throw new CacheLoaderException("SQL error while fetching all StoredEntries", (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        return hashSet;
    }

    protected boolean includeKey(Object key, Set<Object> keysToExclude) {
        return keysToExclude == null || !keysToExclude.contains(key);
    }

    protected abstract String getLoadAllKeysSql();

    protected abstract void loadAllProcess(ResultSet var1, Set<InternalCacheEntry> var2) throws SQLException, CacheLoaderException;

    protected abstract void loadAllProcess(ResultSet var1, Set<InternalCacheEntry> var2, int var3) throws SQLException, CacheLoaderException;

    protected abstract void loadAllKeysProcess(ResultSet var1, Set<Object> var2, Set<Object> var3) throws SQLException, CacheLoaderException;

    protected abstract void toStreamProcess(ResultSet var1, InputStream var2, ObjectOutput var3) throws CacheLoaderException, SQLException, IOException;

    protected abstract boolean fromStreamProcess(Object var1, PreparedStatement var2, ObjectInput var3) throws SQLException, CacheLoaderException, IOException, ClassNotFoundException, InterruptedException;
}

