/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc;

import java.sql.Connection;
import java.util.HashSet;
import org.infinispan.loaders.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.loaders.jdbc.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.connectionfactory.PooledConnectionFactory;
import org.infinispan.persistence.CacheLoaderException;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.PooledConnectionFactoryTest")
public class PooledConnectionFactoryTest {
    private PooledConnectionFactory factory;
    private ConnectionFactoryConfigurationBuilder<?> factoryBuilder;

    @AfterMethod
    public void destroyFacotry() {
        this.factory.stop();
    }

    @Test(enabled=false, description="This test is disabled due to: http://sourceforge.net/tracker/index.php?func=detail&aid=1892195&group_id=25357&atid=383690")
    public void testValuesNoOverrides() throws Exception {
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        this.factoryBuilder = storeBuilder.connectionFactory(UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder));
        this.factory = new PooledConnectionFactory();
        ConnectionFactoryConfiguration factoryConfiguration = (ConnectionFactoryConfiguration)this.factoryBuilder.create();
        this.factory.start(factoryConfiguration, Thread.currentThread().getContextClassLoader());
        int hadcodedMaxPoolSize = this.factory.getPooledDataSource().getMaxPoolSize();
        HashSet<Connection> connections = new HashSet<Connection>();
        for (int i = 0; i < hadcodedMaxPoolSize; ++i) {
            connections.add(this.factory.getConnection());
        }
        assert (connections.size() == hadcodedMaxPoolSize);
        assert (this.factory.getPooledDataSource().getNumBusyConnections() == hadcodedMaxPoolSize);
        for (Connection conn : connections) {
            conn.close();
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 2000L && this.factory.getPooledDataSource().getNumBusyConnections() != 0) {
        }
        assert (this.factory.getPooledDataSource().getNumBusyConnections() == 0);
    }

    @Test(expectedExceptions={CacheLoaderException.class})
    public void testNoDriverClassFound() throws Exception {
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        this.factoryBuilder = UnitTestDatabaseManager.configureBrokenConnectionFactory(storeBuilder);
        this.factory = new PooledConnectionFactory();
        ConnectionFactoryConfiguration factoryConfiguration = (ConnectionFactoryConfiguration)this.factoryBuilder.create();
        this.factory.start(factoryConfiguration, Thread.currentThread().getContextClassLoader());
    }
}

