/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.mixed;

import org.infinispan.Cache;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.BaseCacheStoreTest;
import org.infinispan.persistence.CacheLoaderException;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.mixed.JdbcMixedCacheStore2Test")
public class JdbcMixedCacheStore2Test
extends BaseCacheStoreTest {
    private EmbeddedCacheManager cacheManager;
    private Cache<Object, Object> cache;

    protected AdvancedLoadWriteStore createStore() throws Exception {
        ConfigurationBuilder cc = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcMixedStoreConfigurationBuilder storeBuilder = (JdbcMixedStoreConfigurationBuilder)cc.persistence().addStore(JdbcMixedStoreConfigurationBuilder.class);
        UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.stringTable(), false);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.binaryTable(), true);
        this.cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cc);
        this.cache = this.cacheManager.getCache();
        JdbcMixedCacheStore jdbcMixed = (JdbcMixedCacheStore)TestingUtil.getFirstWriter(this.cache);
        this.csc = jdbcMixed.getConfiguration();
        return jdbcMixed;
    }

    protected Cache getCache() {
        return this.cache;
    }

    protected StreamingMarshaller getMarshaller() {
        return this.cache.getAdvancedCache().getComponentRegistry().getCacheMarshaller();
    }

    @AfterMethod
    public void tearDown() throws CacheLoaderException {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }
}

