/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.stringbased;

import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedStore;
import org.infinispan.persistence.BaseCacheStoreTest;
import org.infinispan.persistence.CacheLoaderException;
import org.infinispan.persistence.InitializationContextImpl;
import org.infinispan.persistence.keymappers.UnsupportedKeyTypeException;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.infinispan.util.DefaultTimeService;
import org.infinispan.util.TimeService;
import org.mockito.Mockito;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.stringbased.JdbcStringBasedStoreTest")
public class JdbcStringBasedStoreTest
extends BaseCacheStoreTest {
    protected AdvancedLoadWriteStore createStore() throws Exception {
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table(), false);
        JdbcStringBasedStore stringBasedCacheStore = new JdbcStringBasedStore();
        stringBasedCacheStore.init((InitializationContext)new InitializationContextImpl((StoreConfiguration)storeBuilder.create(), this.getCache(), this.getMarshaller(), (TimeService)new DefaultTimeService()));
        stringBasedCacheStore.start();
        return stringBasedCacheStore;
    }

    public void testNotCreateConnectionFactory() throws Exception {
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).manageConnectionFactory(false);
        storeBuilder.table().createOnStart(false);
        JdbcStringBasedStore stringBasedCacheStore = new JdbcStringBasedStore();
        stringBasedCacheStore.init((InitializationContext)new InitializationContextImpl((StoreConfiguration)storeBuilder.create(), this.getCache(), this.getMarshaller(), (TimeService)new DefaultTimeService()));
        stringBasedCacheStore.start();
        assert (stringBasedCacheStore.getConnectionFactory() == null);
        ConnectionFactory connectionFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        TableManipulation tableManipulation = (TableManipulation)Mockito.mock(TableManipulation.class);
        tableManipulation.start(connectionFactory);
        tableManipulation.setCacheName("otherName");
        stringBasedCacheStore.initializeConnectionFactory(connectionFactory);
        Mockito.reset((Object[])new Object[]{tableManipulation, connectionFactory});
        tableManipulation.stop();
        stringBasedCacheStore.stop();
    }

    @Test(expectedExceptions={UnsupportedKeyTypeException.class})
    public void testLoadAndStoreMarshalledValues() throws CacheLoaderException {
        super.testLoadAndStoreMarshalledValues();
    }
}

