/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.stringbased;

import java.sql.Connection;
import junit.framework.Assert;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.AbstractJdbcStoreConfigurationChildBuilder;
import org.infinispan.loaders.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.loaders.jdbc.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.connectionfactory.PooledConnectionFactory;
import org.infinispan.loaders.jdbc.stringbased.Person;
import org.infinispan.loaders.jdbc.stringbased.PersonKey2StringMapper;
import org.infinispan.loaders.jdbc.stringbased.TwoWayPersonKey2StringMapper;
import org.infinispan.persistence.CacheLoaderException;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.stringbased.NonStringKeyPreloadTest")
public class NonStringKeyPreloadTest
extends AbstractInfinispanTest {
    public void testPreloadWithKey2StringMapper() throws Exception {
        String mapperName = PersonKey2StringMapper.class.getName();
        ConfigurationBuilder cfg = NonStringKeyPreloadTest.createCacheStoreConfig(mapperName, false, true);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg)){

            public void call() {
                try {
                    this.cm.getCache();
                    assert (false) : " Preload with Key2StringMapper is not supported. Specify an TwoWayKey2StringMapper if you want to support it (or disable preload).";
                }
                catch (CacheException cacheException) {
                    // empty catch block
                }
            }
        });
    }

    public void testPreloadWithTwoWayKey2StringMapper() throws Exception {
        String mapperName = TwoWayPersonKey2StringMapper.class.getName();
        ConfigurationBuilder config = NonStringKeyPreloadTest.createCacheStoreConfig(mapperName, true, true);
        final Person mircea = new Person("Markus", "Mircea", 30);
        final Person dan = new Person("Dan", "Dude", 30);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)config)){

            public void call() {
                Cache cache = this.cm.getCache();
                cache.put((Object)mircea, (Object)"me");
                cache.put((Object)dan, (Object)"mate");
            }
        });
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)config)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                Cache cache = null;
                try {
                    cache = this.cm.getCache();
                    assert (cache.containsKey((Object)mircea));
                    assert (cache.containsKey((Object)dan));
                }
                finally {
                    TestingUtil.clearCacheLoader((Cache)cache);
                }
            }
        });
    }

    public void testPreloadWithTwoWayKey2StringMapperAndBoundedCache() throws Exception {
        String mapperName = TwoWayPersonKey2StringMapper.class.getName();
        ConfigurationBuilder config = NonStringKeyPreloadTest.createCacheStoreConfig(mapperName, true, true);
        config.eviction().strategy(EvictionStrategy.LRU).maxEntries(3);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)config)){

            public void call() {
                AdvancedCache cache = this.cm.getCache().getAdvancedCache();
                for (int i = 0; i < 10; ++i) {
                    Person p = new Person("name" + i, "surname" + i, 30);
                    cache.put((Object)p, (Object)("" + i));
                }
            }
        });
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)config)){

            public void call() {
                AdvancedCache cache = this.cm.getCache().getAdvancedCache();
                Assert.assertEquals((int)3, (int)cache.getDataContainer().size());
                int found = 0;
                for (int i = 0; i < 10; ++i) {
                    Person p = new Person("name" + i, "surname" + i, 30);
                    if (!cache.getDataContainer().containsKey((Object)p)) continue;
                    ++found;
                }
                Assert.assertEquals((int)3, (int)found);
            }
        });
    }

    static ConfigurationBuilder createCacheStoreConfig(String mapperName, boolean wrap, boolean preload) {
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcStringBasedStoreConfigurationBuilder store = ((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)cfg.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).fetchPersistentState(true)).preload(preload)).key2StringMapper(mapperName);
        UnitTestDatabaseManager.buildTableManipulation(store.table(), false);
        if (wrap) {
            ConnectionFactoryConfigurationBuilder<?> tmp = UnitTestDatabaseManager.configureUniqueConnectionFactory((AbstractJdbcStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class));
            ((SharedConnectionFactoryConfigurationBuilder)store.connectionFactory(new SharedConnectionFactoryConfigurationBuilder(store))).read((PooledConnectionFactoryConfiguration)tmp.create());
        } else {
            UnitTestDatabaseManager.configureUniqueConnectionFactory(store);
        }
        return cfg;
    }

    public static class SharedConnectionFactoryConfigurationBuilder<S extends AbstractJdbcStoreConfigurationBuilder<?, S>>
    extends AbstractJdbcStoreConfigurationChildBuilder<S>
    implements ConnectionFactoryConfigurationBuilder<SharedConnectionFactoryConfiguration> {
        private String connectionUrl;
        private String driverClass;
        private String username;
        private String password;

        public SharedConnectionFactoryConfigurationBuilder(AbstractJdbcStoreConfigurationBuilder<?, S> builder) {
            super(builder);
        }

        public void validate() {
        }

        public SharedConnectionFactoryConfiguration create() {
            return new SharedConnectionFactoryConfiguration(this.connectionUrl, this.driverClass, this.username, this.password);
        }

        public Builder<?> read(SharedConnectionFactoryConfiguration template) {
            this.connectionUrl = template.connectionUrl();
            this.driverClass = template.driverClass();
            this.username = template.username();
            this.password = template.password();
            return this;
        }

        public Builder<?> read(PooledConnectionFactoryConfiguration template) {
            this.connectionUrl = template.connectionUrl();
            this.driverClass = template.driverClass();
            this.username = template.username();
            this.password = template.password();
            return this;
        }
    }

    @BuiltBy(value=SharedConnectionFactoryConfigurationBuilder.class)
    public static class SharedConnectionFactoryConfiguration
    extends PooledConnectionFactoryConfiguration {
        SharedConnectionFactoryConfiguration(String connectionUrl, String driverClass, String username, String password) {
            super(connectionUrl, driverClass, username, password);
        }

        public Class<? extends ConnectionFactory> connectionFactoryClass() {
            return SharedConnectionFactory.class;
        }
    }

    public static class SharedConnectionFactory
    extends ConnectionFactory {
        static PooledConnectionFactory sharedFactory;
        static boolean started;

        public void start(ConnectionFactoryConfiguration config, ClassLoader classLoader) throws CacheLoaderException {
            if (!started) {
                sharedFactory = new PooledConnectionFactory();
                sharedFactory.start(config, classLoader);
                started = true;
            }
        }

        public void stop() {
        }

        public Connection getConnection() throws CacheLoaderException {
            return sharedFactory.getConnection();
        }

        public void releaseConnection(Connection conn) {
            sharedFactory.releaseConnection(conn);
        }

        static {
            started = false;
        }
    }
}

