/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.stringbased;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.loaders.jdbc.ManagedConnectionFactoryTest;
import org.infinispan.loaders.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.loaders.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.connectionfactory.ManagedConnectionFactory;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedStore;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.CacheLoaderException;
import org.infinispan.persistence.InitializationContextImpl;
import org.infinispan.persistence.keymappers.UnsupportedKeyTypeException;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.infinispan.util.DefaultTimeService;
import org.infinispan.util.TimeService;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.jdbc.stringbased.StringStoreWithManagedConnectionTest")
public class StringStoreWithManagedConnectionTest
extends ManagedConnectionFactoryTest {
    protected AdvancedLoadWriteStore createStore() throws Exception {
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        storeBuilder.dataSource().jndiUrl(this.getDatasourceLocation());
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table(), false);
        JdbcStringBasedStore stringBasedCacheStore = new JdbcStringBasedStore();
        stringBasedCacheStore.init((InitializationContext)new InitializationContextImpl((StoreConfiguration)storeBuilder.create(), this.getCache(), this.getMarshaller(), (TimeService)new DefaultTimeService()));
        stringBasedCacheStore.start();
        return stringBasedCacheStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoadFromFile() throws Exception {
        EmbeddedCacheManager cm = null;
        try {
            cm = TestCacheManagerFactory.fromXml((String)"configs/managed/str-managed-connection-factory.xml");
            Cache first = cm.getCache("first");
            Cache second = cm.getCache("second");
            StoreConfiguration firstCacheLoaderConfig = (StoreConfiguration)first.getCacheConfiguration().persistence().stores().get(0);
            assert (firstCacheLoaderConfig != null);
            StoreConfiguration secondCacheLoaderConfig = (StoreConfiguration)second.getCacheConfiguration().persistence().stores().get(0);
            assert (secondCacheLoaderConfig != null);
            assert (firstCacheLoaderConfig instanceof JdbcStringBasedStoreConfiguration);
            assert (secondCacheLoaderConfig instanceof JdbcStringBasedStoreConfiguration);
            JdbcStringBasedStore loader = (JdbcStringBasedStore)TestingUtil.getFirstLoader((Cache)first);
            assert (loader.getConnectionFactory() instanceof ManagedConnectionFactory);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
            throw throwable;
        }
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
    }

    @Override
    public String getDatasourceLocation() {
        return "java:/StringStoreWithManagedConnectionTest/DS";
    }

    @Test(expectedExceptions={UnsupportedKeyTypeException.class})
    public void testLoadAndStoreMarshalledValues() throws CacheLoaderException {
        super.testLoadAndStoreMarshalledValues();
    }
}

