/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc;

import org.infinispan.persistence.jdbc.TableName;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.TableNameTest")
public class TableNameTest {
    private static final String IDENTIFIER_QUOTE = "\"";

    @BeforeClass
    public void beforeClass() {
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNullType() {
        new TableName(null, "", "");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNullPrefix() {
        new TableName(IDENTIFIER_QUOTE, null, "");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNullName() {
        new TableName(IDENTIFIER_QUOTE, "", null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testEmptySchema() {
        TableName tableName = new TableName(IDENTIFIER_QUOTE, ".ISPN", "FOOBAR");
        Assert.assertEquals((String)tableName.getSchema(), (String)"");
    }

    public void testSchema() {
        TableName tableName = new TableName(IDENTIFIER_QUOTE, "TEST.ISPN", "FOOBAR");
        Assert.assertEquals((String)tableName.getSchema(), (String)"TEST");
        Assert.assertEquals((String)tableName.getName(), (String)"ISPN_FOOBAR");
        Assert.assertEquals((String)tableName.toString(), (String)"\"TEST\".\"ISPN_FOOBAR\"");
        tableName = new TableName(IDENTIFIER_QUOTE, "ISPN", "FOOBAR");
        Assert.assertEquals((String)tableName.getSchema(), null);
        Assert.assertEquals((String)tableName.getName(), (String)"ISPN_FOOBAR");
        Assert.assertEquals((String)tableName.toString(), (String)"\"ISPN_FOOBAR\"");
    }

    public void testName() {
        TableName tableName = new TableName(IDENTIFIER_QUOTE, "ISPN", "FOOB\u00e4R");
        Assert.assertEquals((String)tableName.toString(), (String)"\"ISPN_FOOB_R\"");
    }
}

