/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.mixed;

import org.infinispan.Cache;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.CacheLoaderException;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.mixed.JdbcMixedStore;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.mixed.JdbcMixedStore2Test")
public class JdbcMixedStore2Test
extends BaseStoreTest {
    private EmbeddedCacheManager cacheManager;
    private Cache<Object, Object> cache;

    protected AdvancedLoadWriteStore createStore() throws Exception {
        ConfigurationBuilder cc = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcMixedStoreConfigurationBuilder storeBuilder = (JdbcMixedStoreConfigurationBuilder)cc.persistence().addStore(JdbcMixedStoreConfigurationBuilder.class);
        UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.stringTable(), false);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.binaryTable(), true);
        this.cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cc);
        this.cache = this.cacheManager.getCache();
        JdbcMixedStore jdbcMixed = (JdbcMixedStore)TestingUtil.getFirstWriter(this.cache);
        this.csc = jdbcMixed.getConfiguration();
        return jdbcMixed;
    }

    protected Cache getCache() {
        return this.cache;
    }

    protected StreamingMarshaller getMarshaller() {
        return this.cache.getAdvancedCache().getComponentRegistry().getCacheMarshaller();
    }

    @AfterMethod
    public void tearDown() throws CacheLoaderException {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }
}

