/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.mixed;

import junit.framework.Assert;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfigurationBuilder;
import org.infinispan.persistence.keymappers.DefaultTwoWayKey2StringMapper;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.jdbc.mixed.JdbcMixedStoreConfigurationTest")
public class JdbcMixedStoreConfigurationTest {
    private JdbcMixedStoreConfiguration config;
    private JdbcMixedStoreConfigurationBuilder storeBuilder;

    @BeforeMethod
    public void setUp() {
        this.storeBuilder = (JdbcMixedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcMixedStoreConfigurationBuilder.class);
        this.storeBuilder.simpleConnection().connectionUrl("url").driverClass("driver");
    }

    public void simpleTest() {
        ((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)this.storeBuilder.binaryTable().createOnStart(false)).dataColumnName("binary_dc")).dataColumnType("binary_dct")).stringTable().createOnStart(true)).dataColumnName("strings_dc")).dataColumnType("strings_dct");
        this.config = this.storeBuilder.create();
        Assert.assertFalse((boolean)this.config.binaryTable().createOnStart());
        Assert.assertTrue((boolean)this.config.stringTable().createOnStart());
        Assert.assertEquals((String)this.config.binaryTable().dataColumnName(), (String)"binary_dc");
        Assert.assertEquals((String)this.config.binaryTable().dataColumnType(), (String)"binary_dct");
        Assert.assertEquals((String)this.config.stringTable().dataColumnName(), (String)"strings_dc");
        Assert.assertEquals((String)this.config.stringTable().dataColumnType(), (String)"strings_dct");
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testSameTableName() {
        ((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)this.storeBuilder.binaryTable().tableNamePrefix("failTable")).stringTable().tableNamePrefix("failTable");
        this.storeBuilder.validate();
    }

    public void testKey2StringMapper() {
        this.storeBuilder.key2StringMapper(DefaultTwoWayKey2StringMapper.class.getName());
        this.config = this.storeBuilder.create();
        Assert.assertEquals((String)this.config.key2StringMapper(), (String)DefaultTwoWayKey2StringMapper.class.getName());
    }

    public void testConcurrencyLevel() {
        this.config = this.storeBuilder.create();
        Assert.assertEquals((int)2048, (int)this.config.lockConcurrencyLevel());
        JdbcMixedStoreConfigurationBuilder storeBuilder2 = ((JdbcMixedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcMixedStoreConfigurationBuilder.class)).read(this.config).lockConcurrencyLevel(12);
        this.config = storeBuilder2.create();
        Assert.assertEquals((int)12, (int)this.config.lockConcurrencyLevel());
    }

    public void voidTestLockAcquisitionTimeout() {
        this.config = this.storeBuilder.create();
        Assert.assertEquals((long)60000L, (long)this.config.lockAcquisitionTimeout());
        JdbcMixedStoreConfigurationBuilder storeBuilder2 = ((JdbcMixedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcMixedStoreConfigurationBuilder.class)).read(this.config).lockConcurrencyLevel(13);
        this.config = storeBuilder2.create();
        Assert.assertEquals((int)13, (int)this.config.lockConcurrencyLevel());
    }

    public void testDatabaseConfiguration() {
        ConfigurationBuilder bld = new ConfigurationBuilder();
        ((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder)((JdbcMixedStoreConfigurationBuilder)bld.clustering().cacheMode(CacheMode.LOCAL).persistence().addStore(JdbcMixedStoreConfigurationBuilder.class)).fetchPersistentState(false)).purgeOnStartup(false)).databaseType(DatabaseType.MYSQL).stringTable().dropOnExit(false)).createOnStart(true)).tableNamePrefix("ISPN6Alpha2_STRING")).idColumnName("ID")).idColumnType("VARCHAR(255)")).dataColumnName("DATA")).dataColumnType("VARBINARY(1000)")).timestampColumnName("TIMESTAMP")).timestampColumnType("BIGINT")).binaryTable().dropOnExit(false)).createOnStart(true)).tableNamePrefix("ISPN6Alpha2_BINARY")).idColumnName("ID")).idColumnType("VARCHAR(255)")).dataColumnName("DATA")).dataColumnType("VARBINARY(1000)")).timestampColumnName("TIMESTAMP")).timestampColumnType("BIGINT")).dataSource().jndiUrl("java:jboss/datasources/ExampleDS");
        Configuration build = bld.build();
        JdbcMixedStoreConfiguration sc = (JdbcMixedStoreConfiguration)build.persistence().stores().get(0);
        Assert.assertEquals((Object)sc.databaseType(), (Object)DatabaseType.MYSQL);
        Assert.assertEquals((Object)sc.binaryTable().databaseType(), (Object)DatabaseType.MYSQL);
        Assert.assertEquals((Object)sc.stringTable().databaseType(), (Object)DatabaseType.MYSQL);
    }
}

