/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.mixed;

import org.infinispan.Cache;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.CacheLoaderException;
import org.infinispan.persistence.jdbc.ManagedConnectionFactoryTest;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.connectionfactory.ManagedConnectionFactory;
import org.infinispan.persistence.jdbc.mixed.JdbcMixedStore;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.mixed.MixedStoreWithManagedConnectionTest")
public class MixedStoreWithManagedConnectionTest
extends ManagedConnectionFactoryTest {
    private EmbeddedCacheManager cacheManager;
    private Cache<Object, Object> cache;

    protected AdvancedLoadWriteStore createStore() throws Exception {
        ConfigurationBuilder cc = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcMixedStoreConfigurationBuilder storeBuilder = (JdbcMixedStoreConfigurationBuilder)cc.persistence().addStore(JdbcMixedStoreConfigurationBuilder.class);
        storeBuilder.dataSource().jndiUrl(this.getDatasourceLocation());
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.stringTable(), false);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.binaryTable(), true);
        ((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)storeBuilder.binaryTable().tableNamePrefix("BINARY_TABLE")).stringTable().tableNamePrefix("STRINGS_TABLE");
        this.cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cc);
        this.cache = this.cacheManager.getCache();
        JdbcMixedStore jdbcMixed = (JdbcMixedStore)TestingUtil.getFirstWriter(this.cache);
        this.csc = jdbcMixed.getConfiguration();
        return jdbcMixed;
    }

    protected Cache getCache() {
        return this.cache;
    }

    protected StreamingMarshaller getMarshaller() {
        return this.cache.getAdvancedCache().getComponentRegistry().getCacheMarshaller();
    }

    @AfterMethod
    public void tearDown() throws CacheLoaderException {
        this.cache.clear();
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoadFromFile() throws Exception {
        EmbeddedCacheManager cm = null;
        try {
            cm = TestCacheManagerFactory.fromXml((String)"configs/managed/mixed-managed-connection-factory.xml");
            Cache first = cm.getCache("first");
            Cache second = cm.getCache("second");
            StoreConfiguration firstCacheLoaderConfig = (StoreConfiguration)first.getCacheConfiguration().persistence().stores().get(0);
            assert (firstCacheLoaderConfig != null);
            StoreConfiguration secondCacheLoaderConfig = (StoreConfiguration)second.getCacheConfiguration().persistence().stores().get(0);
            assert (secondCacheLoaderConfig != null);
            assert (firstCacheLoaderConfig instanceof JdbcMixedStoreConfiguration);
            assert (secondCacheLoaderConfig instanceof JdbcMixedStoreConfiguration);
            JdbcMixedStore loader = (JdbcMixedStore)TestingUtil.getFirstLoader((Cache)first);
            assert (loader.getConnectionFactory() instanceof ManagedConnectionFactory);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
            throw throwable;
        }
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
    }

    @Override
    public String getDatasourceLocation() {
        return "java:/MixedStoreWithManagedConnectionTest/DS";
    }
}

