/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import java.util.concurrent.Executor;
import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.io.ByteBufferFactoryImpl;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.marshall.core.MarshalledEntryFactoryImpl;
import org.infinispan.marshall.core.MarshalledEntryImpl;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.InitializationContextImpl;
import org.infinispan.persistence.jdbc.TableManipulation;
import org.infinispan.persistence.jdbc.TableName;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.stringbased.JdbcStringBasedStore;
import org.infinispan.persistence.jdbc.stringbased.Person;
import org.infinispan.persistence.jdbc.stringbased.PersonKey2StringMapper;
import org.infinispan.persistence.keymappers.UnsupportedKeyTypeException;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.infinispan.util.DefaultTimeService;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.stringbased.JdbcStringBasedStoreAltMapperTest")
public class JdbcStringBasedStoreAltMapperTest {
    AdvancedLoadWriteStore cacheStore;
    private TableManipulation tableManipulation;
    private static final Person MIRCEA = new Person("Mircea", "Markus", 28);
    private static final Person MANIK = new Person("Manik", "Surtani", 18);

    @BeforeTest
    public void createCacheStore() throws PersistenceException {
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = ((JdbcStringBasedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).key2StringMapper(PersonKey2StringMapper.class);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table(), false);
        UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder);
        this.cacheStore = new JdbcStringBasedStore();
        this.cacheStore.init((InitializationContext)new InitializationContextImpl((StoreConfiguration)storeBuilder.create(), BaseStoreTest.mockCache((String)this.getClass().getName()), this.getMarshaller(), (TimeService)new DefaultTimeService(), (ByteBufferFactory)new ByteBufferFactoryImpl(), (MarshalledEntryFactory)new MarshalledEntryFactoryImpl(this.getMarshaller())));
        this.cacheStore.start();
        this.tableManipulation = (TableManipulation)ReflectionUtil.getValue((Object)this.cacheStore, (String)"tableManipulation");
    }

    @AfterMethod
    public void clearStore() throws Exception {
        this.cacheStore.clear();
        assert (this.rowCount() == 0);
    }

    @AfterTest
    public void destroyStore() throws PersistenceException {
        this.cacheStore.stop();
    }

    public void persistUnsupportedObject() throws Exception {
        try {
            this.cacheStore.write((MarshalledEntry)new MarshalledEntryImpl((Object)"key", (Object)"value", null, this.getMarshaller()));
            assert (false) : "exception is expected as PersonKey2StringMapper does not support strings";
        }
        catch (UnsupportedKeyTypeException unsupportedKeyTypeException) {
            // empty catch block
        }
        this.cacheStore.write((MarshalledEntry)new MarshalledEntryImpl((Object)MIRCEA, (Object)"Cluj Napoca", null, this.getMarshaller()));
    }

    public void testStoreLoadRemove() throws Exception {
        assert (this.rowCount() == 0);
        assert (this.cacheStore.load((Object)MIRCEA) == null) : "should not be present in the store";
        String value = "adsdsadsa";
        this.cacheStore.write((MarshalledEntry)new MarshalledEntryImpl((Object)MIRCEA, (Object)value, null, this.getMarshaller()));
        assert (this.rowCount() == 1);
        assert (this.cacheStore.load((Object)MIRCEA).getValue().equals(value));
        assert (!this.cacheStore.delete((Object)MANIK));
        assert (this.cacheStore.load((Object)MIRCEA).getValue().equals(value));
        assert (this.rowCount() == 1);
        assert (this.cacheStore.delete((Object)MIRCEA));
        assert (this.rowCount() == 0);
    }

    public void testClear() throws Exception {
        assert (this.rowCount() == 0);
        this.cacheStore.write((MarshalledEntry)new MarshalledEntryImpl((Object)MIRCEA, (Object)"value", null, this.getMarshaller()));
        this.cacheStore.write((MarshalledEntry)new MarshalledEntryImpl((Object)MANIK, (Object)"value", null, this.getMarshaller()));
        assert (this.rowCount() == 2);
        this.cacheStore.clear();
        assert (this.rowCount() == 0);
    }

    public void testPurgeExpired() throws Exception {
        InternalCacheEntry first = TestInternalCacheEntryFactory.create((Object)MIRCEA, (Object)"val", (long)1000L);
        InternalCacheEntry second = TestInternalCacheEntryFactory.create((Object)MANIK, (Object)"val2");
        this.cacheStore.write(TestingUtil.marshalledEntry((InternalCacheEntry)first, (StreamingMarshaller)this.getMarshaller()));
        this.cacheStore.write(TestingUtil.marshalledEntry((InternalCacheEntry)second, (StreamingMarshaller)this.getMarshaller()));
        Assert.assertEquals((int)this.rowCount(), (int)2);
        Thread.sleep(1100L);
        this.cacheStore.purge((Executor)new WithinThreadExecutor(), null);
        assert (this.rowCount() == 1);
        assert (this.cacheStore.load((Object)MANIK).getValue().equals("val2"));
    }

    private int rowCount() {
        ConnectionFactory connectionFactory = this.getConnection();
        TableName tableName = this.tableManipulation.getTableName();
        return UnitTestDatabaseManager.rowCount(connectionFactory, tableName);
    }

    private ConnectionFactory getConnection() {
        JdbcStringBasedStore store = (JdbcStringBasedStore)this.cacheStore;
        return store.getConnectionFactory();
    }

    protected StreamingMarshaller getMarshaller() {
        return new TestObjectStreamMarshaller(false);
    }
}

