/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.binary;

import java.io.Serializable;
import java.util.concurrent.Executor;
import org.infinispan.Cache;
import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.io.ByteBufferFactoryImpl;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.marshall.core.MarshalledEntryFactoryImpl;
import org.infinispan.marshall.core.MarshalledEntryImpl;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.InternalMetadataImpl;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.InitializationContextImpl;
import org.infinispan.persistence.jdbc.TableManipulation;
import org.infinispan.persistence.jdbc.binary.JdbcBinaryStore;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.infinispan.util.DefaultTimeService;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.mockito.Mockito;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.binary.JdbcBinaryStoreTest")
public class JdbcBinaryStoreTest
extends BaseStoreTest {
    private EmbeddedCacheManager cacheManager;
    private Cache<Object, Object> cache;

    protected AdvancedLoadWriteStore createStore() throws Exception {
        ConfigurationBuilder cc = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcBinaryStoreConfigurationBuilder storeBuilder = (JdbcBinaryStoreConfigurationBuilder)cc.persistence().addStore(JdbcBinaryStoreConfigurationBuilder.class);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table(), true);
        UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder);
        this.cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cc);
        this.cache = this.cacheManager.getCache();
        JdbcBinaryStore jdbcBinaryCacheStore = (JdbcBinaryStore)TestingUtil.getFirstWriter(this.cache);
        assert (jdbcBinaryCacheStore.getConnectionFactory() != null);
        this.csc = jdbcBinaryCacheStore.getConfiguration();
        return jdbcBinaryCacheStore;
    }

    @AfterMethod
    public void tearDown() throws PersistenceException {
        super.tearDown();
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    protected StreamingMarshaller getMarshaller() {
        StreamingMarshaller component = this.cache.getAdvancedCache().getComponentRegistry().getCacheMarshaller();
        assert (component != null);
        return component;
    }

    public void testNotCreateConnectionFactory() throws Exception {
        JdbcBinaryStoreConfigurationBuilder storeBuilder = (JdbcBinaryStoreConfigurationBuilder)((JdbcBinaryStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcBinaryStoreConfigurationBuilder.class)).manageConnectionFactory(false);
        storeBuilder.table().createOnStart(false);
        JdbcBinaryStore jdbcBucketCacheStore = new JdbcBinaryStore();
        jdbcBucketCacheStore.init((InitializationContext)new InitializationContextImpl((StoreConfiguration)storeBuilder.create(), this.getCache(), this.getMarshaller(), (TimeService)new DefaultTimeService(), (ByteBufferFactory)new ByteBufferFactoryImpl(), (MarshalledEntryFactory)new MarshalledEntryFactoryImpl(this.getMarshaller())));
        jdbcBucketCacheStore.start();
        assert (jdbcBucketCacheStore.getConnectionFactory() == null);
        ConnectionFactory connectionFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        TableManipulation tableManipulation = (TableManipulation)Mockito.mock(TableManipulation.class);
        tableManipulation.start(connectionFactory);
        tableManipulation.setCacheName("aName");
        jdbcBucketCacheStore.doConnectionFactoryInitialization(connectionFactory);
        tableManipulation.stop();
        jdbcBucketCacheStore.stop();
    }

    public void testPurgeExpired() throws Exception {
        super.testPurgeExpired();
        UnitTestDatabaseManager.verifyConnectionLeaks(((JdbcBinaryStore)this.cl).getConnectionFactory());
    }

    public void testPurgeExpiredAllCodepaths() throws Exception {
        FixedHashKey k1 = new FixedHashKey(1, "a");
        FixedHashKey k2 = new FixedHashKey(1, "b");
        this.cl.write((MarshalledEntry)new MarshalledEntryImpl((Object)k1, (Object)"value", null, this.getMarshaller()));
        Metadata metadata = TestingUtil.metadata((Integer)1000, null);
        InternalMetadataImpl im = new InternalMetadataImpl(metadata, System.currentTimeMillis(), System.currentTimeMillis());
        this.cl.write((MarshalledEntry)new MarshalledEntryImpl((Object)k2, (Object)"value", (InternalMetadata)im, this.getMarshaller()));
        for (int i = 0; i < 120; ++i) {
            this.cl.write((MarshalledEntry)new MarshalledEntryImpl((Object)new FixedHashKey(i + 10, "non-exp k" + i), (Object)"value", null, this.getMarshaller()));
            this.cl.write((MarshalledEntry)new MarshalledEntryImpl((Object)new FixedHashKey(i + 10, "exp k" + i), (Object)"value", (InternalMetadata)im, this.getMarshaller()));
        }
        TestingUtil.sleepThread((long)1000L);
        assert (this.cl.contains((Object)k1));
        assert (!this.cl.contains((Object)k2));
        this.cl.purge((Executor)new WithinThreadExecutor(), null);
        assert (this.cl.contains((Object)k1));
        assert (!this.cl.contains((Object)k2));
        UnitTestDatabaseManager.verifyConnectionLeaks(((JdbcBinaryStore)this.cl).getConnectionFactory());
    }

    private static final class FixedHashKey
    implements Serializable {
        String s;
        int i;

        private FixedHashKey(int i, String s) {
            this.s = s;
            this.i = i;
        }

        public int hashCode() {
            return this.i;
        }

        public boolean equals(Object other) {
            return other instanceof FixedHashKey && this.s.equals(((FixedHashKey)other).s);
        }
    }
}

