/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.SimpleConnectionFactoryConfiguration;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.jdbc.configuration.XmlFileParsingTest")
public class XmlFileParsingTest
extends AbstractInfinispanTest {
    private EmbeddedCacheManager cacheManager;

    @AfterMethod
    public void cleanup() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    public void testStringKeyedJdbcStore() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:6.0 http://www.infinispan.org/schemas/infinispan-config-6.0.xsd\"\n      xmlns=\"urn:infinispan:config:6.0\">   <default>\n     <persistence>\n       <stringKeyedJdbcStore xmlns=\"urn:infinispan:config:jdbc:6.0\" key2StringMapper=\"DummyKey2StringMapper\" preload=\"true\" shared=\"true\">\n         <connectionPool connectionUrl=\"jdbc:h2:mem:infinispan;DB_CLOSE_DELAY=-1\" username=\"dbuser\" password=\"dbpass\" driverClass=\"org.h2.Driver\"/>\n         <stringKeyedTable prefix=\"entry\" fetchSize=\"34\" batchSize=\"128\" >\n           <idColumn name=\"id\" type=\"VARCHAR\" />\n           <dataColumn name=\"datum\" type=\"BINARY\" />\n           <timestampColumn name=\"version\" type=\"BIGINT\" />\n         </stringKeyedTable>\n         <async enabled=\"true\" />\n       </stringKeyedJdbcStore>\n     </persistence>\n   </default>\n</infinispan>";
        JdbcStringBasedStoreConfiguration store = (JdbcStringBasedStoreConfiguration)this.buildCacheManagerWithCacheStore(config);
        AssertJUnit.assertEquals((int)128, (int)store.table().batchSize());
        AssertJUnit.assertEquals((int)34, (int)store.table().fetchSize());
        AssertJUnit.assertEquals((String)"BINARY", (String)store.table().dataColumnType());
        AssertJUnit.assertEquals((String)"version", (String)store.table().timestampColumnName());
        AssertJUnit.assertTrue((boolean)store.async().enabled());
        AssertJUnit.assertEquals((String)"DummyKey2StringMapper", (String)store.key2StringMapper());
        AssertJUnit.assertTrue((boolean)store.shared());
        AssertJUnit.assertTrue((boolean)store.preload());
        PooledConnectionFactoryConfiguration connectionFactory = (PooledConnectionFactoryConfiguration)store.connectionFactory();
        AssertJUnit.assertEquals((String)"jdbc:h2:mem:infinispan;DB_CLOSE_DELAY=-1", (String)connectionFactory.connectionUrl());
        AssertJUnit.assertEquals((String)"org.h2.Driver", (String)connectionFactory.driverClass());
        AssertJUnit.assertEquals((String)"dbuser", (String)connectionFactory.username());
        AssertJUnit.assertEquals((String)"dbpass", (String)connectionFactory.password());
    }

    public void testBinaryKeyedJdbcStore() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:6.0 http://www.infinispan.org/schemas/infinispan-config-6.0.xsd\"\n      xmlns=\"urn:infinispan:config:6.0\">   <default>\n     <persistence>\n       <binaryKeyedJdbcStore xmlns=\"urn:infinispan:config:jdbc:6.0\" ignoreModifications=\"true\">\n         <simpleConnection connectionUrl=\"jdbc:h2:mem:infinispan;DB_CLOSE_DELAY=-1\" username=\"dbuser\" password=\"dbpass\" driverClass=\"org.h2.Driver\"/>\n         <binaryKeyedTable prefix=\"bucket\" fetchSize=\"34\" batchSize=\"128\">\n           <idColumn name=\"id\" type=\"BINARY\" />\n           <dataColumn name=\"datum\" type=\"BINARY\" />\n           <timestampColumn name=\"version\" type=\"BIGINT\" />\n         </binaryKeyedTable>\n         <singleton enabled=\"true\" />\n       </binaryKeyedJdbcStore>\n     </persistence>\n   </default>\n</infinispan>";
        JdbcBinaryStoreConfiguration store = (JdbcBinaryStoreConfiguration)this.buildCacheManagerWithCacheStore(config);
        AssertJUnit.assertTrue((boolean)store.ignoreModifications());
        AssertJUnit.assertEquals((String)"bucket", (String)store.table().tableNamePrefix());
        AssertJUnit.assertEquals((int)128, (int)store.table().batchSize());
        AssertJUnit.assertEquals((int)34, (int)store.table().fetchSize());
        AssertJUnit.assertEquals((String)"BINARY", (String)store.table().dataColumnType());
        AssertJUnit.assertEquals((String)"version", (String)store.table().timestampColumnName());
        AssertJUnit.assertTrue((boolean)store.singletonStore().enabled());
        SimpleConnectionFactoryConfiguration connectionFactory = (SimpleConnectionFactoryConfiguration)store.connectionFactory();
        AssertJUnit.assertEquals((String)"jdbc:h2:mem:infinispan;DB_CLOSE_DELAY=-1", (String)connectionFactory.connectionUrl());
        AssertJUnit.assertEquals((String)"org.h2.Driver", (String)connectionFactory.driverClass());
        AssertJUnit.assertEquals((String)"dbuser", (String)connectionFactory.username());
        AssertJUnit.assertEquals((String)"dbpass", (String)connectionFactory.password());
    }

    public void testMixedKeyedJdbcStore() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:6.0 http://www.infinispan.org/schemas/infinispan-config-6.0.xsd\"\n      xmlns=\"urn:infinispan:config:6.0\">   <default>\n     <persistence>\n       <mixedKeyedJdbcStore xmlns=\"urn:infinispan:config:jdbc:6.0\" key2StringMapper=\"DummyKey2StringMapper\">\n         <dataSource jndiUrl=\"java:MyDataSource\" />\n         <stringKeyedTable prefix=\"entry\" fetchSize=\"34\" batchSize=\"128\">\n           <idColumn name=\"id\" type=\"VARCHAR\" />\n           <dataColumn name=\"datum\" type=\"BINARY\" />\n           <timestampColumn name=\"version\" type=\"BIGINT\" />\n         </stringKeyedTable>\n         <binaryKeyedTable prefix=\"bucket\" fetchSize=\"44\" batchSize=\"256\">\n           <idColumn name=\"id\" type=\"BINARY\" />\n           <dataColumn name=\"datum\" type=\"BINARY\" />\n           <timestampColumn name=\"version\" type=\"BIGINT\" />\n         </binaryKeyedTable>\n         <async enabled=\"true\" />\n         <singleton enabled=\"true\" />\n       </mixedKeyedJdbcStore>\n     </persistence>\n   </default>\n</infinispan>";
        JdbcMixedStoreConfiguration store = (JdbcMixedStoreConfiguration)this.buildCacheManagerWithCacheStore(config);
        AssertJUnit.assertEquals((String)"entry", (String)store.stringTable().tableNamePrefix());
        AssertJUnit.assertEquals((int)128, (int)store.stringTable().batchSize());
        AssertJUnit.assertEquals((int)34, (int)store.stringTable().fetchSize());
        AssertJUnit.assertEquals((String)"BINARY", (String)store.stringTable().dataColumnType());
        AssertJUnit.assertEquals((String)"version", (String)store.stringTable().timestampColumnName());
        AssertJUnit.assertEquals((String)"bucket", (String)store.binaryTable().tableNamePrefix());
        AssertJUnit.assertEquals((int)256, (int)store.binaryTable().batchSize());
        AssertJUnit.assertEquals((int)44, (int)store.binaryTable().fetchSize());
        AssertJUnit.assertEquals((String)"BINARY", (String)store.binaryTable().dataColumnType());
        AssertJUnit.assertEquals((String)"version", (String)store.binaryTable().timestampColumnName());
        AssertJUnit.assertTrue((boolean)store.async().enabled());
        AssertJUnit.assertTrue((boolean)store.singletonStore().enabled());
        AssertJUnit.assertEquals((String)"DummyKey2StringMapper", (String)store.key2StringMapper());
    }

    private StoreConfiguration buildCacheManagerWithCacheStore(String config) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        this.cacheManager = TestCacheManagerFactory.fromStream((InputStream)is);
        AssertJUnit.assertEquals((int)1, (int)this.cacheManager.getDefaultCacheConfiguration().persistence().stores().size());
        return (StoreConfiguration)this.cacheManager.getDefaultCacheConfiguration().persistence().stores().get(0);
    }
}

