/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.binary;

import org.infinispan.Cache;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jdbc.ManagedConnectionFactoryTest;
import org.infinispan.persistence.jdbc.binary.JdbcBinaryStore;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.connectionfactory.ManagedConnectionFactory;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.binary.BinaryStoreWithManagedConnectionTest")
public class BinaryStoreWithManagedConnectionTest
extends ManagedConnectionFactoryTest {
    private EmbeddedCacheManager cacheManager;
    private Cache<Object, Object> cache;

    protected AdvancedLoadWriteStore createStore() throws Exception {
        ConfigurationBuilder cc = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcBinaryStoreConfigurationBuilder storeBuilder = (JdbcBinaryStoreConfigurationBuilder)cc.persistence().addStore(JdbcBinaryStoreConfigurationBuilder.class);
        storeBuilder.dataSource().jndiUrl(this.getDatasourceLocation());
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table(), true);
        this.cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cc);
        this.cache = this.cacheManager.getCache();
        JdbcBinaryStore jdbcBinaryCacheStore = (JdbcBinaryStore)TestingUtil.getFirstWriter(this.cache);
        assert (jdbcBinaryCacheStore.getConnectionFactory() instanceof ManagedConnectionFactory);
        this.csc = jdbcBinaryCacheStore.getConfiguration();
        return jdbcBinaryCacheStore;
    }

    @AfterMethod
    public void tearDown() throws PersistenceException {
        super.tearDown();
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    protected StreamingMarshaller getMarshaller() {
        StreamingMarshaller component = this.cache.getAdvancedCache().getComponentRegistry().getCacheMarshaller();
        assert (component != null);
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoadFromFile() throws Exception {
        EmbeddedCacheManager cm;
        block10: {
            cm = null;
            try {
                cm = TestCacheManagerFactory.fromXml((String)"configs/managed/binary-managed-connection-factory.xml");
                Cache first = cm.getCache("first");
                Cache second = cm.getCache("second");
                StoreConfiguration firstCacheLoaderConfig = (StoreConfiguration)first.getCacheConfiguration().persistence().stores().get(0);
                assert (firstCacheLoaderConfig != null);
                StoreConfiguration secondCacheLoaderConfig = (StoreConfiguration)second.getCacheConfiguration().persistence().stores().get(0);
                assert (secondCacheLoaderConfig != null);
                assert (firstCacheLoaderConfig instanceof JdbcBinaryStoreConfiguration);
                assert (secondCacheLoaderConfig instanceof JdbcBinaryStoreConfiguration);
                JdbcBinaryStore loader = (JdbcBinaryStore)TestingUtil.getFirstLoader((Cache)first);
                if ($assertionsDisabled || loader.getConnectionFactory() instanceof ManagedConnectionFactory) break block10;
                throw new AssertionError();
            }
            catch (Throwable throwable) {
                try {
                    TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getDatasourceLocation() {
        return "java:/BinaryStoreWithManagedConnectionTest/DS";
    }
}

