/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.io.ByteBufferFactoryImpl;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.marshall.core.MarshalledEntryFactoryImpl;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.InitializationContextImpl;
import org.infinispan.persistence.jdbc.TableManipulation;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.stringbased.JdbcStringBasedStore;
import org.infinispan.persistence.keymappers.UnsupportedKeyTypeException;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.infinispan.util.DefaultTimeService;
import org.infinispan.util.TimeService;
import org.mockito.Mockito;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.stringbased.JdbcStringBasedStoreTest")
public class JdbcStringBasedStoreTest
extends BaseStoreTest {
    protected AdvancedLoadWriteStore createStore() throws Exception {
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table(), false);
        JdbcStringBasedStore stringBasedCacheStore = new JdbcStringBasedStore();
        stringBasedCacheStore.init((InitializationContext)new InitializationContextImpl((StoreConfiguration)storeBuilder.create(), this.getCache(), this.getMarshaller(), (TimeService)new DefaultTimeService(), (ByteBufferFactory)new ByteBufferFactoryImpl(), (MarshalledEntryFactory)new MarshalledEntryFactoryImpl(this.getMarshaller())));
        stringBasedCacheStore.start();
        return stringBasedCacheStore;
    }

    public void testNotCreateConnectionFactory() throws Exception {
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).manageConnectionFactory(false);
        storeBuilder.table().createOnStart(false);
        JdbcStringBasedStore stringBasedCacheStore = new JdbcStringBasedStore();
        stringBasedCacheStore.init((InitializationContext)new InitializationContextImpl((StoreConfiguration)storeBuilder.create(), this.getCache(), this.getMarshaller(), (TimeService)new DefaultTimeService(), (ByteBufferFactory)new ByteBufferFactoryImpl(), (MarshalledEntryFactory)new MarshalledEntryFactoryImpl(this.getMarshaller())));
        stringBasedCacheStore.start();
        assert (stringBasedCacheStore.getConnectionFactory() == null);
        ConnectionFactory connectionFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        TableManipulation tableManipulation = (TableManipulation)Mockito.mock(TableManipulation.class);
        tableManipulation.start(connectionFactory);
        tableManipulation.setCacheName("otherName");
        stringBasedCacheStore.initializeConnectionFactory(connectionFactory);
        Mockito.reset((Object[])new Object[]{tableManipulation, connectionFactory});
        tableManipulation.stop();
        stringBasedCacheStore.stop();
    }

    @Test(expectedExceptions={UnsupportedKeyTypeException.class})
    public void testLoadAndStoreMarshalledValues() throws PersistenceException {
        super.testLoadAndStoreMarshalledValues();
    }
}

