/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.persistence.jdbc.Dialect;
import org.infinispan.persistence.jdbc.JdbcUtil;
import org.infinispan.persistence.jdbc.TableName;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

public class TableManipulation
implements Cloneable {
    private static final Log log = (Log)LogFactory.getLog(TableManipulation.class, Log.class);
    public static final int DEFAULT_FETCH_SIZE = 100;
    public static final int DEFAULT_BATCH_SIZE = 128;
    private String identifierQuoteString;
    private String cacheName;
    TableManipulationConfiguration config;
    private ConnectionFactory connectionFactory;
    private String insertRowSql;
    private String updateRowSql;
    private String selectRowSql;
    private String selectIdRowSql;
    private String deleteRowSql;
    private String loadAllRowsSql;
    private String countRowsSql;
    private String loadAllNonExpiredRowsSql;
    private String deleteAllRows;
    private String selectExpiredRowsSql;
    private String deleteExpiredRowsSql;
    private String loadSomeRowsSql;
    private Dialect dialect;
    private String loadAllKeysBinarySql;
    private String loadAllKeysStringSql;
    private TableName tableName;

    public TableManipulation(TableManipulationConfiguration config, Dialect dialect) {
        this.config = config;
        this.dialect = dialect;
    }

    public TableManipulation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(Connection connection, TableName tableName) throws PersistenceException {
        if (tableName == null) {
            throw new NullPointerException("table name is mandatory");
        }
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String schemaPattern = tableName.getSchema();
            if (schemaPattern == null) {
                switch (this.getDialect()) {
                    case ORACLE: {
                        schemaPattern = metaData.getUserName();
                        break;
                    }
                }
            }
            rs = metaData.getTables(null, schemaPattern, tableName.getName(), new String[]{"TABLE"});
            boolean bl = rs.next();
            JdbcUtil.safeClose(rs);
            return bl;
        }
        catch (SQLException e) {
            if (log.isTraceEnabled()) {
                log.tracef(e, "SQLException occurs while checking the table %s", tableName);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            JdbcUtil.safeClose(rs);
        }
    }

    public void createTable(Connection conn) throws PersistenceException {
        this.assertMandatoryElementsPresent();
        String createTableDdl = "CREATE TABLE " + this.getTableName() + "(" + this.config.idColumnName() + " " + this.config.idColumnType() + " NOT NULL, " + this.config.dataColumnName() + " " + this.config.dataColumnType() + ", " + this.config.timestampColumnName() + " " + this.config.timestampColumnType() + ", PRIMARY KEY (" + this.config.idColumnName() + "))";
        if (log.isTraceEnabled()) {
            log.tracef("Creating table with following DDL: '%s'.", createTableDdl);
        }
        this.executeUpdateSql(conn, createTableDdl);
    }

    private void assertMandatoryElementsPresent() throws PersistenceException {
        this.assertNotNull(this.cacheName, "cacheName needed in order to create table");
    }

    private void assertNotNull(String keyColumnType, String message) throws PersistenceException {
        if (keyColumnType == null || keyColumnType.trim().length() == 0) {
            throw new PersistenceException(message);
        }
    }

    private void executeUpdateSql(Connection conn, String sql) throws PersistenceException {
        Statement statement = null;
        try {
            statement = conn.createStatement();
            statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            log.errorCreatingTable(sql, e);
            throw new PersistenceException((Throwable)e);
        }
        finally {
            JdbcUtil.safeClose(statement);
        }
    }

    public void dropTable(Connection conn) throws PersistenceException {
        String dropTableDdl = "DROP TABLE " + this.getTableName();
        String clearTable = "DELETE FROM " + this.getTableName();
        this.executeUpdateSql(conn, clearTable);
        if (log.isTraceEnabled()) {
            log.tracef("Dropping table with following DDL '%s'", dropTableDdl);
        }
        this.executeUpdateSql(conn, dropTableDdl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ConnectionFactory connectionFactory) throws PersistenceException {
        this.connectionFactory = connectionFactory;
        if (this.config.createOnStart()) {
            Connection conn = null;
            try {
                conn = this.connectionFactory.getConnection();
                if (!this.tableExists(conn, this.getTableName())) {
                    this.createTable(conn);
                }
            }
            finally {
                this.connectionFactory.releaseConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws PersistenceException {
        if (this.config.dropOnExit()) {
            Connection conn = null;
            try {
                conn = this.connectionFactory.getConnection();
                this.dropTable(conn);
            }
            finally {
                this.connectionFactory.releaseConnection(conn);
            }
        }
    }

    public String getInsertRowSql() {
        if (this.insertRowSql == null) {
            this.insertRowSql = "INSERT INTO " + this.getTableName() + " (" + this.config.dataColumnName() + ", " + this.config.timestampColumnName() + ", " + this.config.idColumnName() + ") VALUES(?,?,?)";
        }
        return this.insertRowSql;
    }

    public String getUpdateRowSql() {
        if (this.updateRowSql == null) {
            switch (this.getDialect()) {
                case SYBASE: {
                    this.updateRowSql = "UPDATE " + this.getTableName() + " SET " + this.config.dataColumnName() + " = ? , " + this.config.timestampColumnName() + "=? WHERE " + this.config.idColumnName() + " = convert(" + this.config.idColumnType() + "," + "?)";
                    break;
                }
                case POSTGRES: {
                    this.updateRowSql = "UPDATE " + this.getTableName() + " SET " + this.config.dataColumnName() + " = ? , " + this.config.timestampColumnName() + "=? WHERE " + this.config.idColumnName() + " = cast(? as " + this.config.idColumnType() + ")";
                    break;
                }
                default: {
                    this.updateRowSql = "UPDATE " + this.getTableName() + " SET " + this.config.dataColumnName() + " = ? , " + this.config.timestampColumnName() + "=? WHERE " + this.config.idColumnName() + " = ?";
                }
            }
        }
        return this.updateRowSql;
    }

    public String getSelectRowSql() {
        if (this.selectRowSql == null) {
            switch (this.getDialect()) {
                case SYBASE: {
                    this.selectRowSql = "SELECT " + this.config.idColumnName() + ", " + this.config.dataColumnName() + " FROM " + this.getTableName() + " WHERE " + this.config.idColumnName() + " = convert(" + this.config.idColumnType() + "," + "?)";
                    break;
                }
                case POSTGRES: {
                    this.selectRowSql = "SELECT " + this.config.idColumnName() + ", " + this.config.dataColumnName() + " FROM " + this.getTableName() + " WHERE " + this.config.idColumnName() + " = cast(? as " + this.config.idColumnType() + ")";
                    break;
                }
                default: {
                    this.selectRowSql = "SELECT " + this.config.idColumnName() + ", " + this.config.dataColumnName() + " FROM " + this.getTableName() + " WHERE " + this.config.idColumnName() + " = ?";
                }
            }
        }
        return this.selectRowSql;
    }

    public String getSelectIdRowSql() {
        if (this.selectIdRowSql == null) {
            switch (this.getDialect()) {
                case SYBASE: {
                    this.selectIdRowSql = "SELECT " + this.config.idColumnName() + " FROM " + this.getTableName() + " WHERE " + this.config.idColumnName() + " = convert(" + this.config.idColumnType() + "," + "?)";
                    break;
                }
                case POSTGRES: {
                    this.selectIdRowSql = "SELECT " + this.config.idColumnName() + " FROM " + this.getTableName() + " WHERE " + this.config.idColumnName() + " = cast(? as " + this.config.idColumnType() + ")";
                    break;
                }
                default: {
                    this.selectIdRowSql = "SELECT " + this.config.idColumnName() + " FROM " + this.getTableName() + " WHERE " + this.config.idColumnName() + " = ?";
                }
            }
        }
        return this.selectIdRowSql;
    }

    public String getCountRowsSql() {
        if (this.countRowsSql == null) {
            this.countRowsSql = "SELECT COUNT(*) FROM " + this.getTableName();
        }
        return this.countRowsSql;
    }

    public String getDeleteRowSql() {
        if (this.deleteRowSql == null) {
            switch (this.getDialect()) {
                case SYBASE: {
                    this.deleteRowSql = "DELETE FROM " + this.getTableName() + " WHERE " + this.config.idColumnName() + " = convert(" + this.config.idColumnType() + "," + "?)";
                    break;
                }
                case POSTGRES: {
                    this.deleteRowSql = "DELETE FROM " + this.getTableName() + " WHERE " + this.config.idColumnName() + " = cast(? as " + this.config.idColumnType() + ")";
                    break;
                }
                default: {
                    this.deleteRowSql = "DELETE FROM " + this.getTableName() + " WHERE " + this.config.idColumnName() + " = ?";
                }
            }
        }
        return this.deleteRowSql;
    }

    public String getLoadNonExpiredAllRowsSql() {
        if (this.loadAllNonExpiredRowsSql == null) {
            this.loadAllNonExpiredRowsSql = "SELECT " + this.config.dataColumnName() + "," + this.config.idColumnName() + ", " + this.config.timestampColumnName() + " FROM " + this.getTableName() + " WHERE " + this.config.timestampColumnName() + " > ? OR " + this.config.timestampColumnName() + " < 0";
        }
        return this.loadAllNonExpiredRowsSql;
    }

    public String getLoadAllRowsSql() {
        if (this.loadAllRowsSql == null) {
            this.loadAllRowsSql = "SELECT " + this.config.dataColumnName() + "," + this.config.idColumnName() + " FROM " + this.getTableName();
        }
        return this.loadAllRowsSql;
    }

    public String getDeleteAllRowsSql() {
        if (this.deleteAllRows == null) {
            this.deleteAllRows = "DELETE FROM " + this.getTableName();
        }
        return this.deleteAllRows;
    }

    public String getSelectExpiredRowsSql() {
        if (this.selectExpiredRowsSql == null) {
            this.selectExpiredRowsSql = this.getLoadAllRowsSql() + " WHERE " + this.config.timestampColumnName() + "< ?";
        }
        return this.selectExpiredRowsSql;
    }

    public String getDeleteExpiredRowsSql() {
        if (this.deleteExpiredRowsSql == null) {
            this.deleteExpiredRowsSql = "DELETE FROM " + this.getTableName() + " WHERE " + this.config.timestampColumnName() + "< ? AND " + this.config.timestampColumnName() + "> 0";
        }
        return this.deleteExpiredRowsSql;
    }

    public TableManipulation clone() {
        try {
            return (TableManipulation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public TableName getTableName() {
        if (this.tableName == null) {
            this.tableName = new TableName(this.getIdentifierQuoteString(), this.config.tableNamePrefix(), this.cacheName);
        }
        return this.tableName;
    }

    public boolean tableExists(Connection connection) throws PersistenceException {
        return this.tableExists(connection, this.getTableName());
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
        this.tableName = null;
    }

    public boolean isVariableLimitSupported() {
        Dialect type = this.getDialect();
        return type != Dialect.DB2 && type != Dialect.DB2_390 && type != Dialect.SYBASE;
    }

    public String getLoadSomeRowsSql() {
        if (this.loadSomeRowsSql == null) {
            switch (this.getDialect()) {
                case ORACLE: {
                    this.loadSomeRowsSql = String.format("SELECT %s, %s FROM (SELECT %s, %s FROM %s) WHERE ROWNUM <= ?", this.config.dataColumnName(), this.config.idColumnName(), this.config.dataColumnName(), this.config.idColumnName(), this.getTableName());
                    break;
                }
                case DB2: 
                case DB2_390: 
                case DERBY: {
                    this.loadSomeRowsSql = String.format("SELECT %s, %s FROM %s FETCH FIRST ? ROWS ONLY", this.config.dataColumnName(), this.config.idColumnName(), this.getTableName());
                    break;
                }
                case INFORMIX: 
                case INTERBASE: 
                case FIREBIRD: {
                    this.loadSomeRowsSql = String.format("SELECT FIRST ? %s, %s FROM %s", this.config.dataColumnName(), this.config.idColumnName(), this.getTableName());
                    break;
                }
                case SQL_SERVER: {
                    this.loadSomeRowsSql = String.format("SELECT TOP (?) %s, %s FROM %s", this.config.dataColumnName(), this.config.idColumnName(), this.getTableName());
                    break;
                }
                case SYBASE: 
                case ACCESS: 
                case HSQL: {
                    this.loadSomeRowsSql = String.format("SELECT TOP ? %s, %s FROM %s", this.config.dataColumnName(), this.config.idColumnName(), this.getTableName());
                    break;
                }
                default: {
                    this.loadSomeRowsSql = String.format("SELECT %s, %s FROM %s LIMIT ?", this.config.dataColumnName(), this.config.idColumnName(), this.getTableName());
                }
            }
        }
        return this.loadSomeRowsSql;
    }

    public String getLoadAllKeysBinarySql() {
        if (this.loadAllKeysBinarySql == null) {
            this.loadAllKeysBinarySql = String.format("SELECT %s FROM %s", this.config.dataColumnName(), this.getTableName());
        }
        return this.loadAllKeysBinarySql;
    }

    public String getLoadAllKeysStringSql() {
        if (this.loadAllKeysStringSql == null) {
            this.loadAllKeysStringSql = String.format("SELECT %s FROM %s", this.config.idColumnName(), this.getTableName());
        }
        return this.loadAllKeysStringSql;
    }

    public int getFetchSize() {
        return this.getDialect() == Dialect.MYSQL ? Integer.MIN_VALUE : this.config.fetchSize();
    }

    public int getBatchSize() {
        return this.config.batchSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dialect getDialect() {
        if (this.dialect == null) {
            String dbProduct;
            Connection connection = null;
            try {
                connection = this.connectionFactory.getConnection();
                dbProduct = connection.getMetaData().getDatabaseProductName();
                this.dialect = this.guessDialect(dbProduct);
            }
            catch (Exception e) {
                log.debug("Unable to guess dialect from JDBC metadata.", e);
            }
            finally {
                this.connectionFactory.releaseConnection(connection);
            }
            if (this.dialect == null) {
                log.debug("Unable to detect database dialect using connection metadata.  Attempting to guess on driver name.");
                try {
                    connection = this.connectionFactory.getConnection();
                    dbProduct = this.connectionFactory.getConnection().getMetaData().getDriverName();
                    this.dialect = this.guessDialect(dbProduct);
                }
                catch (Exception e) {
                    log.debug("Unable to guess database dialect from JDBC driver name.", e);
                }
                finally {
                    this.connectionFactory.releaseConnection(connection);
                }
            }
            if (this.dialect == null) {
                throw new CacheConfigurationException("Unable to detect database dialect from JDBC driver name or connection metadata.  Please provide this manually using the 'dialect' property in your configuration.  Supported database dialect strings are " + Arrays.toString((Object[])Dialect.values()));
            }
            log.debugf("Guessing database dialect as '%s'.  If this is incorrect, please specify the correct dialect using the 'dialect' attribute in your configuration.  Supported database dialect strings are %s", (Object)this.dialect, Arrays.toString((Object[])Dialect.values()));
        }
        return this.dialect;
    }

    private Dialect guessDialect(String name) {
        Dialect type = null;
        if (name != null) {
            if (name.toLowerCase().contains("mysql")) {
                type = Dialect.MYSQL;
            } else if (name.toLowerCase().contains("postgres")) {
                type = Dialect.POSTGRES;
            } else if (name.toLowerCase().contains("derby")) {
                type = Dialect.DERBY;
            } else if (name.toLowerCase().contains("hsql") || name.toLowerCase().contains("hypersonic")) {
                type = Dialect.HSQL;
            } else if (name.toLowerCase().contains("h2")) {
                type = Dialect.H2;
            } else if (name.toLowerCase().contains("sqlite")) {
                type = Dialect.SQLITE;
            } else if (name.toLowerCase().contains("db2")) {
                type = Dialect.DB2;
            } else if (name.toLowerCase().contains("informix")) {
                type = Dialect.INFORMIX;
            } else if (name.toLowerCase().contains("interbase")) {
                type = Dialect.INTERBASE;
            } else if (name.toLowerCase().contains("firebird")) {
                type = Dialect.FIREBIRD;
            } else if (name.toLowerCase().contains("sqlserver") || name.toLowerCase().contains("microsoft")) {
                type = Dialect.SQL_SERVER;
            } else if (name.toLowerCase().contains("access")) {
                type = Dialect.ACCESS;
            } else if (name.toLowerCase().contains("oracle")) {
                type = Dialect.ORACLE;
            } else if (name.toLowerCase().contains("adaptive")) {
                type = Dialect.SYBASE;
            }
        }
        return type;
    }

    public String getIdentifierQuoteString() {
        if (this.identifierQuoteString == null) {
            switch (this.getDialect()) {
                case MYSQL: {
                    this.identifierQuoteString = "`";
                    break;
                }
                default: {
                    this.identifierQuoteString = "\"";
                }
            }
        }
        return this.identifierQuoteString;
    }
}

