/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.SimpleConnectionFactoryConfiguration;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.jdbc.configuration.XmlFileParsingTest")
public class XmlFileParsingTest
extends AbstractInfinispanTest {
    protected EmbeddedCacheManager cacheManager;

    @AfterMethod
    public void cleanup() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    public void testStringKeyedJdbcStore() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:7.0 http://www.infinispan.org/schemas/infinispan-config-7.0.xsd\"\n      xmlns=\"urn:infinispan:config:7.0\">   <cache-container default-cache=\"default\">\n      <local-cache name=\"default\">\n     <persistence>\n       <string-keyed-jdbc-store xmlns=\"urn:infinispan:config:store:jdbc:7.0\" key-to-string-mapper=\"DummyKey2StringMapper\" shared=\"true\"                                 preload=\"true\" read-only=\"true\" fetch-state=\"true\" purge=\"true\" singleton=\"false\" dialect=\"H2\">\n         <connection-pool connection-url=\"jdbc:h2:mem:infinispan;DB_CLOSE_DELAY=-1\" username=\"dbuser\" password=\"dbpass\" driver=\"org.h2.Driver\"/>\n         <string-keyed-table prefix=\"entry\" fetch-size=\"34\" batch-size=\"128\" >\n           <id-column name=\"id\" type=\"VARCHAR\" />\n           <data-column name=\"datum\" type=\"BINARY\" />\n           <timestamp-column name=\"version\" type=\"BIGINT\" />\n         </string-keyed-table>\n         <write-behind />\n       </string-keyed-jdbc-store>\n     </persistence>\n   </local-cache></cache-container>\n</infinispan>";
        JdbcStringBasedStoreConfiguration store = (JdbcStringBasedStoreConfiguration)this.buildCacheManagerWithCacheStore(config);
        AssertJUnit.assertEquals((int)128, (int)store.table().batchSize());
        AssertJUnit.assertEquals((int)34, (int)store.table().fetchSize());
        AssertJUnit.assertEquals((String)"BINARY", (String)store.table().dataColumnType());
        AssertJUnit.assertEquals((String)"version", (String)store.table().timestampColumnName());
        AssertJUnit.assertTrue((boolean)store.async().enabled());
        AssertJUnit.assertEquals((String)"DummyKey2StringMapper", (String)store.key2StringMapper());
        AssertJUnit.assertTrue((boolean)store.shared());
        AssertJUnit.assertTrue((boolean)store.preload());
        AssertJUnit.assertEquals((Object)DatabaseType.H2, (Object)store.dialect());
        PooledConnectionFactoryConfiguration connectionFactory = (PooledConnectionFactoryConfiguration)store.connectionFactory();
        AssertJUnit.assertEquals((String)"jdbc:h2:mem:infinispan;DB_CLOSE_DELAY=-1", (String)connectionFactory.connectionUrl());
        AssertJUnit.assertEquals((String)"org.h2.Driver", (String)connectionFactory.driverClass());
        AssertJUnit.assertEquals((String)"dbuser", (String)connectionFactory.username());
        AssertJUnit.assertEquals((String)"dbpass", (String)connectionFactory.password());
        AssertJUnit.assertTrue((boolean)store.ignoreModifications());
        AssertJUnit.assertTrue((boolean)store.fetchPersistentState());
        AssertJUnit.assertTrue((boolean)store.purgeOnStartup());
        AssertJUnit.assertFalse((boolean)store.singletonStore().enabled());
    }

    public void testBinaryKeyedJdbcStore() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:7.0 http://www.infinispan.org/schemas/infinispan-config-7.0.xsd\"\n      xmlns=\"urn:infinispan:config:7.0\">   <cache-container default-cache=\"default\">\n      <local-cache name=\"default\">\n     <persistence>\n       <binary-keyed-jdbc-store xmlns=\"urn:infinispan:config:store:jdbc:7.0\" read-only=\"true\" singleton=\"true\" dialect=\"H2\">\n         <simple-connection connection-url=\"jdbc:h2:mem:infinispan;DB_CLOSE_DELAY=-1\" username=\"dbuser\" password=\"dbpass\" driver=\"org.h2.Driver\"/>\n         <binary-keyed-table prefix=\"bucket\" fetch-size=\"34\" batch-size=\"128\">\n           <id-column name=\"id\" type=\"BINARY\" />\n           <data-column name=\"datum\" type=\"BINARY\" />\n           <timestamp-column name=\"version\" type=\"BIGINT\" />\n         </binary-keyed-table>\n       </binary-keyed-jdbc-store>\n     </persistence>\n   </local-cache></cache-container>\n</infinispan>";
        JdbcBinaryStoreConfiguration store = (JdbcBinaryStoreConfiguration)this.buildCacheManagerWithCacheStore(config);
        AssertJUnit.assertTrue((boolean)store.ignoreModifications());
        AssertJUnit.assertEquals((String)"bucket", (String)store.table().tableNamePrefix());
        AssertJUnit.assertEquals((int)128, (int)store.table().batchSize());
        AssertJUnit.assertEquals((int)34, (int)store.table().fetchSize());
        AssertJUnit.assertEquals((String)"BINARY", (String)store.table().dataColumnType());
        AssertJUnit.assertEquals((String)"version", (String)store.table().timestampColumnName());
        AssertJUnit.assertFalse((boolean)store.purgeOnStartup());
        AssertJUnit.assertTrue((boolean)store.singletonStore().enabled());
        AssertJUnit.assertEquals((Object)DatabaseType.H2, (Object)store.dialect());
        SimpleConnectionFactoryConfiguration connectionFactory = (SimpleConnectionFactoryConfiguration)store.connectionFactory();
        AssertJUnit.assertEquals((String)"jdbc:h2:mem:infinispan;DB_CLOSE_DELAY=-1", (String)connectionFactory.connectionUrl());
        AssertJUnit.assertEquals((String)"org.h2.Driver", (String)connectionFactory.driverClass());
        AssertJUnit.assertEquals((String)"dbuser", (String)connectionFactory.username());
        AssertJUnit.assertEquals((String)"dbpass", (String)connectionFactory.password());
    }

    public void testMixedKeyedJdbcStore() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:7.0 http://www.infinispan.org/schemas/infinispan-config-7.0.xsd\"\n      xmlns=\"urn:infinispan:config:7.0\">   <cache-container default-cache=\"default\">\n      <local-cache name=\"default\">\n     <persistence>\n       <mixed-keyed-jdbc-store xmlns=\"urn:infinispan:config:store:jdbc:7.0\" key-to-string-mapper=\"DummyKey2StringMapper\" singleton=\"true\" dialect=\"H2\">\n         <data-source jndi-url=\"java:MyDataSource\" />\n         <string-keyed-table prefix=\"entry\" fetch-size=\"34\" batch-size=\"128\">\n           <id-column name=\"id\" type=\"VARCHAR\" />\n           <data-column name=\"datum\" type=\"BINARY\" />\n           <timestamp-column name=\"version\" type=\"BIGINT\" />\n         </string-keyed-table>\n         <binary-keyed-table prefix=\"bucket\" fetch-size=\"44\" batch-size=\"256\">\n           <id-column name=\"id\" type=\"BINARY\" />\n           <data-column name=\"datum\" type=\"BINARY\" />\n           <timestamp-column name=\"version\" type=\"BIGINT\" />\n         </binary-keyed-table>\n         <write-behind />\n       </mixed-keyed-jdbc-store>\n     </persistence>\n   </local-cache></cache-container>\n</infinispan>";
        JdbcMixedStoreConfiguration store = (JdbcMixedStoreConfiguration)this.buildCacheManagerWithCacheStore(config);
        AssertJUnit.assertEquals((String)"entry", (String)store.stringTable().tableNamePrefix());
        AssertJUnit.assertEquals((int)128, (int)store.stringTable().batchSize());
        AssertJUnit.assertEquals((int)34, (int)store.stringTable().fetchSize());
        AssertJUnit.assertEquals((String)"BINARY", (String)store.stringTable().dataColumnType());
        AssertJUnit.assertEquals((String)"version", (String)store.stringTable().timestampColumnName());
        AssertJUnit.assertEquals((String)"bucket", (String)store.binaryTable().tableNamePrefix());
        AssertJUnit.assertEquals((int)256, (int)store.binaryTable().batchSize());
        AssertJUnit.assertEquals((int)44, (int)store.binaryTable().fetchSize());
        AssertJUnit.assertEquals((String)"BINARY", (String)store.binaryTable().dataColumnType());
        AssertJUnit.assertEquals((String)"version", (String)store.binaryTable().timestampColumnName());
        AssertJUnit.assertEquals((Object)DatabaseType.H2, (Object)store.dialect());
        AssertJUnit.assertTrue((boolean)store.async().enabled());
        AssertJUnit.assertTrue((boolean)store.singletonStore().enabled());
        AssertJUnit.assertFalse((boolean)store.purgeOnStartup());
        AssertJUnit.assertEquals((String)"DummyKey2StringMapper", (String)store.key2StringMapper());
    }

    private StoreConfiguration buildCacheManagerWithCacheStore(String config) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        this.cacheManager = TestCacheManagerFactory.fromStream((InputStream)is);
        AssertJUnit.assertEquals((int)1, (int)this.cacheManager.getDefaultCacheConfiguration().persistence().stores().size());
        return (StoreConfiguration)this.cacheManager.getDefaultCacheConfiguration().persistence().stores().get(0);
    }
}

