/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.jdbc.TableManipulation;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.stringbased.JdbcStringBasedStore;
import org.infinispan.persistence.keymappers.UnsupportedKeyTypeException;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.stringbased.JdbcStringBasedStoreTest")
public class JdbcStringBasedStoreTest
extends BaseStoreTest {
    protected AdvancedLoadWriteStore createStore() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)builder.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table(), false);
        JdbcStringBasedStore stringBasedCacheStore = new JdbcStringBasedStore();
        stringBasedCacheStore.init(this.createContext(builder.build()));
        return stringBasedCacheStore;
    }

    public void testNotCreateConnectionFactory() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)builder.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).manageConnectionFactory(false);
        storeBuilder.table().createOnStart(false);
        JdbcStringBasedStore stringBasedCacheStore = new JdbcStringBasedStore();
        stringBasedCacheStore.init(this.createContext(builder.build()));
        stringBasedCacheStore.start();
        AssertJUnit.assertNull((Object)stringBasedCacheStore.getConnectionFactory());
        ConnectionFactory connectionFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        TableManipulation tableManipulation = (TableManipulation)Mockito.mock(TableManipulation.class);
        tableManipulation.start(connectionFactory);
        tableManipulation.setCacheName("otherName");
        stringBasedCacheStore.initializeConnectionFactory(connectionFactory);
        Mockito.reset((Object[])new Object[]{tableManipulation, connectionFactory});
        tableManipulation.stop();
        stringBasedCacheStore.stop();
    }

    @Test(expectedExceptions={UnsupportedKeyTypeException.class})
    public void testLoadAndStoreMarshalledValues() throws PersistenceException {
        super.testLoadAndStoreMarshalledValues();
    }

    protected boolean storePurgesAllExpired() {
        return false;
    }
}

