/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.mixed;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.persistence.jdbc.ManagedConnectionFactoryTest;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.connectionfactory.ManagedConnectionFactory;
import org.infinispan.persistence.jdbc.mixed.JdbcMixedStore;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.mixed.MixedStoreWithManagedConnectionTest")
public class MixedStoreWithManagedConnectionTest
extends ManagedConnectionFactoryTest {
    protected AdvancedLoadWriteStore createStore() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcMixedStoreConfigurationBuilder storeBuilder = (JdbcMixedStoreConfigurationBuilder)builder.persistence().addStore(JdbcMixedStoreConfigurationBuilder.class);
        storeBuilder.dataSource().jndiUrl(this.getDatasourceLocation());
        UnitTestDatabaseManager.setDialect((AbstractJdbcStoreConfigurationBuilder)storeBuilder);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.stringTable(), false);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.binaryTable(), true);
        ((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)storeBuilder.binaryTable().tableNamePrefix("BINARY_TABLE")).stringTable().tableNamePrefix("STRINGS_TABLE");
        JdbcMixedStore jdbcMixed = new JdbcMixedStore();
        jdbcMixed.init(this.createContext(builder.build()));
        return jdbcMixed;
    }

    public void testLoadFromFile() throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)"configs/managed/mixed-managed-connection-factory.xml"), true){

            public void call() {
                Cache first = this.cm.getCache("first");
                Cache second = this.cm.getCache("second");
                StoreConfiguration firstCacheLoaderConfig = (StoreConfiguration)first.getCacheConfiguration().persistence().stores().get(0);
                AssertJUnit.assertNotNull((Object)firstCacheLoaderConfig);
                StoreConfiguration secondCacheLoaderConfig = (StoreConfiguration)second.getCacheConfiguration().persistence().stores().get(0);
                AssertJUnit.assertNotNull((Object)secondCacheLoaderConfig);
                AssertJUnit.assertTrue((boolean)(firstCacheLoaderConfig instanceof JdbcMixedStoreConfiguration));
                AssertJUnit.assertTrue((boolean)(secondCacheLoaderConfig instanceof JdbcMixedStoreConfiguration));
                JdbcMixedStore loader = (JdbcMixedStore)TestingUtil.getFirstLoader((Cache)first);
                AssertJUnit.assertTrue((boolean)(loader.getConnectionFactory() instanceof ManagedConnectionFactory));
            }
        });
    }

    @Override
    public String getDatasourceLocation() {
        return "java:/MixedStoreWithManagedConnectionTest/DS";
    }

    protected boolean storePurgesAllExpired() {
        return false;
    }
}

