/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.infinispan.persistence.jdbc.JdbcUtil;
import org.infinispan.persistence.jdbc.TableManipulation;
import org.infinispan.persistence.jdbc.TableName;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.SimpleConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.connectionfactory.PooledConnectionFactory;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.mockito.Mockito;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.TableManipulationTest")
public class TableManipulationTest {
    Connection connection;
    TableManipulation tableManipulation;
    private ConnectionFactoryConfiguration factoryConfiguration;

    @BeforeTest
    public void createConnection() throws Exception {
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        UnitTestDatabaseManager.setDialect((AbstractJdbcStoreConfigurationBuilder)storeBuilder);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table(), false);
        this.factoryConfiguration = (ConnectionFactoryConfiguration)UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder).create();
        this.tableManipulation = new TableManipulation(storeBuilder.table().create(), storeBuilder.create().dialect());
        if (this.factoryConfiguration instanceof SimpleConnectionFactoryConfiguration) {
            SimpleConnectionFactoryConfiguration simpleConfiguration = (SimpleConnectionFactoryConfiguration)this.factoryConfiguration;
            this.connection = DriverManager.getConnection(simpleConfiguration.connectionUrl(), simpleConfiguration.username(), simpleConfiguration.password());
        } else if (this.factoryConfiguration instanceof PooledConnectionFactoryConfiguration) {
            PooledConnectionFactoryConfiguration pooledConfiguration = (PooledConnectionFactoryConfiguration)this.factoryConfiguration;
            this.connection = DriverManager.getConnection(pooledConfiguration.connectionUrl(), pooledConfiguration.username(), pooledConfiguration.password());
        }
        this.tableManipulation.setCacheName("aName");
    }

    @AfterTest
    public void closeConnection() throws SQLException {
        this.connection.close();
    }

    public void testConnectionLeakGuessDialect() throws Exception {
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table(), false);
        TableManipulation tableManipulation = new TableManipulation(storeBuilder.table().create(), null);
        tableManipulation.setCacheName("GuessDialect");
        PooledConnectionFactory factory = new PooledConnectionFactory();
        ConnectionFactoryConfiguration config = (ConnectionFactoryConfiguration)UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder).create();
        factory.start(config, Thread.currentThread().getContextClassLoader());
        tableManipulation.start((ConnectionFactory)factory);
        tableManipulation.getUpdateRowSql();
        UnitTestDatabaseManager.verifyConnectionLeaks((ConnectionFactory)factory);
        tableManipulation.stop();
        factory.stop();
    }

    public void testInsufficientConfigParams() throws Exception {
        block2: {
            Connection mockConnection = (Connection)Mockito.mock(Connection.class);
            Statement mockStatement = (Statement)Mockito.mock(Statement.class);
            Mockito.when((Object)mockConnection.createStatement()).thenReturn((Object)mockStatement);
            TableManipulation other = this.tableManipulation.clone();
            try {
                other.createTable(mockConnection);
            }
            catch (PersistenceException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"We do not expect a failure here");
            }
        }
    }

    public void testCreateTable() throws Exception {
        assert (!TableManipulationTest.existsTable(this.connection, this.tableManipulation.getTableName()));
        this.tableManipulation.createTable(this.connection);
        assert (TableManipulationTest.existsTable(this.connection, this.tableManipulation.getTableName()));
    }

    @Test(dependsOnMethods={"testCreateTable"})
    public void testExists() throws PersistenceException {
        assert (this.tableManipulation.tableExists(this.connection));
        assert (!this.tableManipulation.tableExists(this.connection, new TableName("\"", "", "does_not_exist")));
    }

    public void testExistsWithSchema() throws PersistenceException {
    }

    @Test(dependsOnMethods={"testExists"})
    public void testDrop() throws Exception {
        assert (this.tableManipulation.tableExists(this.connection));
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement("INSERT INTO " + this.tableManipulation.getTableName() + "(ID_COLUMN) values(?)");
            ps.setString(1, System.currentTimeMillis() + "");
            assert (1 == ps.executeUpdate());
        }
        catch (Throwable throwable) {
            JdbcUtil.safeClose(ps);
            throw throwable;
        }
        JdbcUtil.safeClose((Statement)ps);
        this.tableManipulation.dropTable(this.connection);
        assert (!this.tableManipulation.tableExists(this.connection));
    }

    public void testTableQuoting() throws Exception {
        this.tableManipulation.setCacheName("my.cache");
        assert (!TableManipulationTest.existsTable(this.connection, this.tableManipulation.getTableName()));
        this.tableManipulation.createTable(this.connection);
        assert (TableManipulationTest.existsTable(this.connection, this.tableManipulation.getTableName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean existsTable(Connection connection, TableName tableName) throws Exception {
        boolean bl;
        Statement st = connection.createStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery("select * from " + tableName);
            bl = true;
            JdbcUtil.safeClose((ResultSet)rs);
        }
        catch (SQLException e) {
            boolean bl2 = false;
            return bl2;
        }
        finally {
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose((Statement)st);
        }
        JdbcUtil.safeClose((Statement)st);
        return bl;
    }
}

