/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.binary;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.persistence.jdbc.ManagedConnectionFactoryTest;
import org.infinispan.persistence.jdbc.binary.JdbcBinaryStore;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.connectionfactory.ManagedConnectionFactory;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.binary.BinaryStoreWithManagedConnectionTest")
public class BinaryStoreWithManagedConnectionTest
extends ManagedConnectionFactoryTest {
    protected AdvancedLoadWriteStore createStore() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcBinaryStoreConfigurationBuilder storeBuilder = (JdbcBinaryStoreConfigurationBuilder)builder.persistence().addStore(JdbcBinaryStoreConfigurationBuilder.class);
        storeBuilder.dataSource().jndiUrl(this.getDatasourceLocation());
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table(), true);
        JdbcBinaryStore jdbcBinaryStore = new JdbcBinaryStore();
        jdbcBinaryStore.init(this.createContext(builder.build()));
        return jdbcBinaryStore;
    }

    public void testLoadFromFile() throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)"configs/managed/binary-managed-connection-factory.xml"), true){

            public void call() {
                Cache first = this.cm.getCache("first");
                Cache second = this.cm.getCache("second");
                StoreConfiguration firstCacheLoaderConfig = (StoreConfiguration)first.getCacheConfiguration().persistence().stores().get(0);
                AssertJUnit.assertNotNull((Object)firstCacheLoaderConfig);
                StoreConfiguration secondCacheLoaderConfig = (StoreConfiguration)second.getCacheConfiguration().persistence().stores().get(0);
                AssertJUnit.assertNotNull((Object)secondCacheLoaderConfig);
                AssertJUnit.assertTrue((boolean)(firstCacheLoaderConfig instanceof JdbcBinaryStoreConfiguration));
                AssertJUnit.assertTrue((boolean)(secondCacheLoaderConfig instanceof JdbcBinaryStoreConfiguration));
                JdbcBinaryStore loader = (JdbcBinaryStore)TestingUtil.getFirstLoader((Cache)first);
                AssertJUnit.assertTrue((boolean)(loader.getConnectionFactory() instanceof ManagedConnectionFactory));
            }
        });
    }

    @Override
    public String getDatasourceLocation() {
        return "java:/BinaryStoreWithManagedConnectionTest/DS";
    }
}

