/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.binary;

import java.io.Serializable;
import java.util.concurrent.Executor;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.persistence.BaseStoreTest;
import org.infinispan.persistence.jdbc.TableManipulation;
import org.infinispan.persistence.jdbc.binary.JdbcBinaryStore;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.binary.JdbcBinaryStoreTest")
public class JdbcBinaryStoreTest
extends BaseStoreTest {
    protected AdvancedLoadWriteStore createStore() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcBinaryStoreConfigurationBuilder storeBuilder = (JdbcBinaryStoreConfigurationBuilder)builder.persistence().addStore(JdbcBinaryStoreConfigurationBuilder.class);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table(), true);
        UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder);
        JdbcBinaryStore jdbcBinaryCacheStore = new JdbcBinaryStore();
        jdbcBinaryCacheStore.init(this.createContext(builder.build()));
        return jdbcBinaryCacheStore;
    }

    public void testNotCreateConnectionFactory() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcBinaryStoreConfigurationBuilder storeBuilder = (JdbcBinaryStoreConfigurationBuilder)((JdbcBinaryStoreConfigurationBuilder)builder.persistence().addStore(JdbcBinaryStoreConfigurationBuilder.class)).manageConnectionFactory(false);
        storeBuilder.table().createOnStart(false);
        JdbcBinaryStore jdbcBucketCacheStore = new JdbcBinaryStore();
        jdbcBucketCacheStore.init(this.createContext(builder.build()));
        jdbcBucketCacheStore.start();
        AssertJUnit.assertNull((Object)jdbcBucketCacheStore.getConnectionFactory());
        ConnectionFactory connectionFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        TableManipulation tableManipulation = (TableManipulation)Mockito.mock(TableManipulation.class);
        tableManipulation.start(connectionFactory);
        tableManipulation.setCacheName("aName");
        jdbcBucketCacheStore.doConnectionFactoryInitialization(connectionFactory);
        tableManipulation.stop();
        jdbcBucketCacheStore.stop();
    }

    public void testPurgeExpired() throws Exception {
        super.testPurgeExpired();
        UnitTestDatabaseManager.verifyConnectionLeaks(((JdbcBinaryStore)this.cl).getConnectionFactory());
    }

    public void testPurgeExpiredAllCodepaths() throws Exception {
        FixedHashKey k1 = new FixedHashKey(1, "a");
        FixedHashKey k2 = new FixedHashKey(1, "b");
        this.cl.write(this.marshalledEntry(k1, "value", null));
        Metadata metadata = TestingUtil.metadata((Integer)1000, null);
        InternalMetadataImpl im = new InternalMetadataImpl(metadata, this.timeService.wallClockTime(), this.timeService.wallClockTime());
        this.cl.write(this.marshalledEntry(k2, "value", (InternalMetadata)im));
        for (int i = 0; i < 120; ++i) {
            this.cl.write(this.marshalledEntry(new FixedHashKey(i + 10, "non-exp k" + i), "value", null));
            this.cl.write(this.marshalledEntry(new FixedHashKey(i + 10, "exp k" + i), "value", (InternalMetadata)im));
        }
        this.timeService.advance(1001L);
        this.assertContains(k1, true);
        this.assertContains(k2, false);
        this.cl.purge((Executor)new WithinThreadExecutor(), null);
        this.assertContains(k1, true);
        this.assertContains(k2, false);
        UnitTestDatabaseManager.verifyConnectionLeaks(((JdbcBinaryStore)this.cl).getConnectionFactory());
    }

    public void testCacheSize() {
        long lifespan = 3000L;
        for (int i = 0; i < 240; ++i) {
            if (i % 2 == 0) {
                this.cl.write(this.marshalledEntry(this.internalCacheEntry("key" + i, "v1", lifespan)));
                continue;
            }
            this.cl.write(this.marshalledEntry(this.internalCacheEntry("key" + i, "v1", -1L)));
        }
        AssertJUnit.assertEquals((int)this.cl.size(), (int)240);
        this.timeService.advance(lifespan + 1L);
        AssertJUnit.assertEquals((int)this.cl.size(), (int)120);
    }

    private static final class FixedHashKey
    implements Serializable {
        String s;
        int i;

        private FixedHashKey(int i, String s) {
            this.s = s;
            this.i = i;
        }

        public int hashCode() {
            return this.i;
        }

        public boolean equals(Object other) {
            return other instanceof FixedHashKey && this.s.equals(((FixedHashKey)other).s);
        }

        public String toString() {
            return "FixedHashKey{key='" + this.s + '\'' + ", hashCode=" + this.i + '}';
        }
    }
}

