/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.mixed;

import java.util.Set;
import java.util.concurrent.Executor;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryImpl;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.persistence.jdbc.TableManipulation;
import org.infinispan.persistence.jdbc.TableName;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.persistence.jdbc.mixed.JdbcMixedStore;
import org.infinispan.persistence.jdbc.stringbased.Person;
import org.infinispan.persistence.keymappers.DefaultTwoWayKey2StringMapper;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.mixed.JdbcMixedStoreTest")
public class JdbcMixedStoreTest {
    private AdvancedLoadWriteStore cacheStore;
    private TableManipulation stringsTm;
    private TableManipulation binaryTm;
    private ConnectionFactoryConfig cfc;
    private static final Person MIRCEA = new Person("Mircea", "Markus", 28);
    private static final Person MANIK = new Person("Manik", "Surtani", 18);
    private EmbeddedCacheManager cacheManager;
    private Cache<Object, Object> cache;

    @BeforeMethod
    public void createCacheStore() throws PersistenceException {
        ConfigurationBuilder cc = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcMixedStoreConfigurationBuilder storeBuilder = (JdbcMixedStoreConfigurationBuilder)cc.persistence().addStore(JdbcMixedStoreConfigurationBuilder.class);
        UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder);
        UnitTestDatabaseManager.setDialect((AbstractJdbcStoreConfigurationBuilder)storeBuilder);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.stringTable(), false);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.binaryTable(), true);
        ((JdbcMixedStoreConfigurationBuilder.MixedTableManipulationConfigurationBuilder)storeBuilder.stringTable().tableNamePrefix("STRINGS_TABLE")).key2StringMapper(DefaultTwoWayKey2StringMapper.class).binaryTable().tableNamePrefix("BINARY_TABLE");
        this.cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cc);
        this.cache = this.cacheManager.getCache();
        this.cacheStore = (AdvancedLoadWriteStore)TestingUtil.getFirstWriter(this.cache);
        this.stringsTm = (TableManipulation)ReflectionUtil.getValue((Object)((JdbcMixedStore)this.cacheStore).getStringStore(), (String)"tableManipulation");
        this.binaryTm = (TableManipulation)ReflectionUtil.getValue((Object)((JdbcMixedStore)this.cacheStore).getBinaryStore(), (String)"tableManipulation");
    }

    protected StreamingMarshaller getMarshaller() {
        return this.cache.getAdvancedCache().getComponentRegistry().getCacheMarshaller();
    }

    @AfterMethod
    public void tearDown() throws PersistenceException {
        this.cacheStore.clear();
        this.assertBinaryRowCount(0);
        this.assertStringsRowCount(0);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }

    public void testMixedStore() throws Exception {
        this.cacheStore.write((MarshalledEntry)new MarshalledEntryImpl((Object)"String", (Object)"someValue", null, this.getMarshaller()));
        this.assertStringsRowCount(1);
        this.assertBinaryRowCount(0);
        this.cacheStore.write((MarshalledEntry)new MarshalledEntryImpl((Object)MIRCEA, (Object)"value", null, this.getMarshaller()));
        this.assertStringsRowCount(1);
        this.assertStringsRowCount(1);
        assert (this.cacheStore.load((Object)MIRCEA).getValue().equals("value"));
        assert (this.cacheStore.load((Object)"String").getValue().equals("someValue"));
    }

    public void testMultipleEntriesWithSameHashCode() throws Exception {
        Person one = new Person("Mircea", "Markus", 28);
        Person two = new Person("Manik", "Surtani", 28);
        one.setHashCode(100);
        two.setHashCode(100);
        this.cacheStore.write((MarshalledEntry)new MarshalledEntryImpl((Object)one, (Object)"value", null, this.getMarshaller()));
        this.assertBinaryRowCount(1);
        this.assertStringsRowCount(0);
        this.cacheStore.write((MarshalledEntry)new MarshalledEntryImpl((Object)two, (Object)"otherValue", null, this.getMarshaller()));
        this.assertBinaryRowCount(1);
        this.assertStringsRowCount(0);
        assert (this.cacheStore.load((Object)one).getValue().equals("value"));
        assert (this.cacheStore.load((Object)two).getValue().equals("otherValue"));
    }

    public void testClear() throws Exception {
        this.cacheStore.write((MarshalledEntry)new MarshalledEntryImpl((Object)"String", (Object)"someValue", null, this.getMarshaller()));
        this.assertRowCounts(0, 1);
        this.cacheStore.write((MarshalledEntry)new MarshalledEntryImpl((Object)MIRCEA, (Object)"value", null, this.getMarshaller()));
        this.assertRowCounts(1, 1);
        this.cacheStore.clear();
        this.assertRowCounts(0, 0);
    }

    private MarshalledEntryImpl marshalledEntry(Object key, Object value) {
        return new MarshalledEntryImpl(key, value, null, this.getMarshaller());
    }

    public void testLoadAll() throws Exception {
        MarshalledEntryImpl first = this.marshalledEntry("String", "someValue");
        MarshalledEntryImpl second = this.marshalledEntry("String2", "someValue");
        MarshalledEntryImpl third = this.marshalledEntry(MIRCEA, "value1");
        MarshalledEntryImpl forth = this.marshalledEntry(MANIK, "value2");
        this.cacheStore.write((MarshalledEntry)first);
        this.cacheStore.write((MarshalledEntry)second);
        this.cacheStore.write((MarshalledEntry)third);
        this.cacheStore.write((MarshalledEntry)forth);
        this.assertRowCounts(2, 2);
        Set entries = TestingUtil.allEntries((AdvancedLoadWriteStore)this.cacheStore);
        assert (entries.size() == 4) : "Expected 4 and got: " + entries;
        assert (entries.contains(first));
        assert (entries.contains(second));
        assert (entries.contains(third));
        assert (entries.contains(forth));
    }

    public void testPurgeExpired() throws Exception {
        MarshalledEntryImpl first = new MarshalledEntryImpl((Object)"String", (Object)"someValue", (InternalMetadata)TestingUtil.internalMetadata((Long)1000L, null), this.getMarshaller());
        MarshalledEntryImpl second = new MarshalledEntryImpl((Object)MIRCEA, (Object)"value1", (InternalMetadata)TestingUtil.internalMetadata((Long)1000L, null), this.getMarshaller());
        this.cacheStore.write((MarshalledEntry)first);
        this.cacheStore.write((MarshalledEntry)second);
        this.assertRowCounts(1, 1);
        Thread.sleep(1200L);
        this.cacheStore.purge((Executor)new WithinThreadExecutor(), null);
        this.assertRowCounts(0, 0);
    }

    public void testPurgeExpiredWithRemainingEntries() throws Exception {
        MarshalledEntryImpl first = new MarshalledEntryImpl((Object)"String", (Object)"someValue", (InternalMetadata)TestingUtil.internalMetadata((Long)1000L, null), this.getMarshaller());
        MarshalledEntryImpl second = this.marshalledEntry("String2", "someValue");
        MarshalledEntryImpl third = new MarshalledEntryImpl((Object)MIRCEA, (Object)"value1", (InternalMetadata)TestingUtil.internalMetadata((Long)1000L, null), this.getMarshaller());
        MarshalledEntryImpl forth = this.marshalledEntry(MANIK, "value1");
        this.cacheStore.write((MarshalledEntry)first);
        this.cacheStore.write((MarshalledEntry)second);
        this.cacheStore.write((MarshalledEntry)third);
        this.cacheStore.write((MarshalledEntry)forth);
        this.assertRowCounts(2, 2);
        Thread.sleep(1200L);
        this.cacheStore.purge((Executor)new WithinThreadExecutor(), null);
        this.assertRowCounts(1, 1);
    }

    private void assertRowCounts(int binary, int strings) {
        this.assertBinaryRowCount(binary);
        this.assertStringsRowCount(strings);
    }

    private void assertStringsRowCount(int rowCount) {
        JdbcMixedStore store = (JdbcMixedStore)this.cacheStore;
        ConnectionFactory connectionFactory = store.getConnectionFactory();
        TableName tableName = this.stringsTm.getTableName();
        int value = UnitTestDatabaseManager.rowCount(connectionFactory, tableName);
        assert (value == rowCount) : "Expected " + rowCount + " rows, actual value is " + value;
    }

    private void assertBinaryRowCount(int rowCount) {
        JdbcMixedStore store = (JdbcMixedStore)this.cacheStore;
        ConnectionFactory connectionFactory = store.getConnectionFactory();
        TableName tableName = this.binaryTm.getTableName();
        int value = UnitTestDatabaseManager.rowCount(connectionFactory, tableName);
        assert (value == rowCount) : "Expected " + rowCount + " rows, actual value is " + value;
    }
}

