/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.serializer.AbstractConfigurationSerializerTest;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(testName="persistence.jdbc.configuration.ConfigurationSerializerTest", groups={"functional"})
public class ConfigurationSerializerTest
extends AbstractConfigurationSerializerTest {
    @DataProvider(name="configurationFiles")
    public Object[][] configurationFiles() {
        return new Object[][]{{"configs/binary.xml"}, {"configs/mixed.xml"}, {"configs/string-based.xml"}};
    }

    protected void compareStoreConfiguration(String name, StoreConfiguration beforeStore, StoreConfiguration afterStore) {
        AbstractJdbcStoreConfiguration after;
        AbstractJdbcStoreConfiguration before;
        if (beforeStore instanceof AbstractJdbcStoreConfiguration) {
            before = (AbstractJdbcStoreConfiguration)beforeStore;
            after = (AbstractJdbcStoreConfiguration)afterStore;
            AssertJUnit.assertEquals((String)("Configuration " + name + " JDBC connection factory"), (Object)before.connectionFactory(), (Object)after.connectionFactory());
        }
        if (beforeStore instanceof JdbcStringBasedStoreConfiguration) {
            before = (JdbcStringBasedStoreConfiguration)beforeStore;
            after = (JdbcStringBasedStoreConfiguration)afterStore;
            this.compareAttributeSets("Configuration " + name + " table", before.table().attributes(), after.table().attributes(), new String[0]);
        } else if (beforeStore instanceof JdbcBinaryStoreConfiguration) {
            before = (JdbcBinaryStoreConfiguration)beforeStore;
            after = (JdbcBinaryStoreConfiguration)afterStore;
            this.compareAttributeSets("Configuration " + name + " table", before.table().attributes(), after.table().attributes(), new String[0]);
        } else if (beforeStore instanceof JdbcMixedStoreConfiguration) {
            before = (JdbcMixedStoreConfiguration)beforeStore;
            after = (JdbcMixedStoreConfiguration)afterStore;
            this.compareAttributeSets("Configuration " + name + " string table", before.stringTable().attributes(), after.stringTable().attributes(), new String[0]);
            this.compareAttributeSets("Configuration " + name + " binary table", before.binaryTable().attributes(), after.binaryTable().attributes(), new String[0]);
        }
        super.compareStoreConfiguration(name, beforeStore, afterStore);
    }
}

