/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import java.util.concurrent.Executor;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryImpl;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.stringbased.JdbcStringBasedStore;
import org.infinispan.persistence.jdbc.stringbased.Person;
import org.infinispan.persistence.jdbc.stringbased.PersonKey2StringMapper;
import org.infinispan.persistence.jdbc.table.management.TableManager;
import org.infinispan.persistence.jdbc.table.management.TableName;
import org.infinispan.persistence.keymappers.UnsupportedKeyTypeException;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.infinispan.util.PersistenceMockUtil;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.stringbased.JdbcStringBasedStoreAltMapperTest")
public class JdbcStringBasedStoreAltMapperTest
extends AbstractInfinispanTest {
    private AdvancedLoadWriteStore cacheStore;
    private TableManager tableManager;
    private static final Person MIRCEA = new Person("Mircea", "Markus", 28);
    private static final Person MANIK = new Person("Manik", "Surtani", 18);
    private StreamingMarshaller marshaller;

    @BeforeClass
    public void createCacheStore() throws PersistenceException {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcStringBasedStoreConfigurationBuilder storeBuilder = ((JdbcStringBasedStoreConfigurationBuilder)builder.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).key2StringMapper(PersonKey2StringMapper.class);
        UnitTestDatabaseManager.buildTableManipulation(storeBuilder.table(), false);
        UnitTestDatabaseManager.configureUniqueConnectionFactory(storeBuilder);
        this.cacheStore = new JdbcStringBasedStore();
        this.marshaller = new TestObjectStreamMarshaller();
        this.cacheStore.init(PersistenceMockUtil.createContext((String)((Object)((Object)this)).getClass().getSimpleName(), (Configuration)builder.build(), (StreamingMarshaller)this.marshaller));
        this.cacheStore.start();
        this.tableManager = (TableManager)ReflectionUtil.getValue((Object)this.cacheStore, (String)"tableManager");
    }

    @AfterMethod
    public void clearStore() throws Exception {
        this.cacheStore.clear();
        this.assertRowCount(0);
    }

    @AfterClass
    public void destroyStore() throws PersistenceException {
        this.cacheStore.stop();
        this.marshaller.stop();
    }

    public void persistUnsupportedObject() throws Exception {
        try {
            this.cacheStore.write((MarshalledEntry)new MarshalledEntryImpl((Object)"key", (Object)"value", null, this.marshaller));
            AssertJUnit.fail((String)"exception is expected as PersonKey2StringMapper does not support strings");
        }
        catch (UnsupportedKeyTypeException unsupportedKeyTypeException) {
            // empty catch block
        }
        this.cacheStore.write((MarshalledEntry)new MarshalledEntryImpl((Object)MIRCEA, (Object)"Cluj Napoca", null, this.marshaller));
    }

    public void testStoreLoadRemove() throws Exception {
        this.assertRowCount(0);
        AssertJUnit.assertNull((String)"should not be present in the store", (Object)this.cacheStore.load((Object)MIRCEA));
        String value = "adsdsadsa";
        this.cacheStore.write((MarshalledEntry)new MarshalledEntryImpl((Object)MIRCEA, (Object)value, null, this.marshaller));
        this.assertRowCount(1);
        AssertJUnit.assertEquals((Object)value, (Object)this.cacheStore.load((Object)MIRCEA).getValue());
        AssertJUnit.assertFalse((boolean)this.cacheStore.delete((Object)MANIK));
        AssertJUnit.assertEquals((Object)value, (Object)this.cacheStore.load((Object)MIRCEA).getValue());
        this.assertRowCount(1);
        AssertJUnit.assertTrue((boolean)this.cacheStore.delete((Object)MIRCEA));
        this.assertRowCount(0);
    }

    public void testClear() throws Exception {
        this.assertRowCount(0);
        this.cacheStore.write((MarshalledEntry)new MarshalledEntryImpl((Object)MIRCEA, (Object)"value", null, this.marshaller));
        this.cacheStore.write((MarshalledEntry)new MarshalledEntryImpl((Object)MANIK, (Object)"value", null, this.marshaller));
        this.assertRowCount(2);
        this.cacheStore.clear();
        this.assertRowCount(0);
    }

    public void testPurgeExpired() throws Exception {
        InternalCacheEntry first = TestInternalCacheEntryFactory.create((Object)MIRCEA, (Object)"val", (long)1000L);
        InternalCacheEntry second = TestInternalCacheEntryFactory.create((Object)MANIK, (Object)"val2");
        this.cacheStore.write(TestingUtil.marshalledEntry((InternalCacheEntry)first, (StreamingMarshaller)this.marshaller));
        this.cacheStore.write(TestingUtil.marshalledEntry((InternalCacheEntry)second, (StreamingMarshaller)this.marshaller));
        this.assertRowCount(2);
        Thread.sleep(1100L);
        this.cacheStore.purge((Executor)new WithinThreadExecutor(), null);
        this.assertRowCount(1);
        AssertJUnit.assertEquals((Object)"val2", (Object)this.cacheStore.load((Object)MANIK).getValue());
    }

    private int rowCount() {
        ConnectionFactory connectionFactory = this.getConnection();
        TableName tableName = this.tableManager.getTableName();
        return UnitTestDatabaseManager.rowCount(connectionFactory, tableName);
    }

    private ConnectionFactory getConnection() {
        JdbcStringBasedStore store = (JdbcStringBasedStore)this.cacheStore;
        return store.getConnectionFactory();
    }

    private void assertRowCount(int size) {
        AssertJUnit.assertEquals((int)size, (int)this.rowCount());
    }
}

