/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.ExternalPojo;
import org.infinispan.persistence.jdbc.TableManagerTest;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.stringbased.JdbcStringBasedStore;
import org.infinispan.persistence.jdbc.table.management.TableName;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.TableNameUniquenessTest")
public class TableNameUniquenessTest
extends AbstractInfinispanTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForJdbcStringBasedCacheStore() throws Exception {
        EmbeddedCacheManager cm = null;
        try {
            cm = TestCacheManagerFactory.fromXml((String)"configs/string-based.xml");
            Cache first = cm.getCache("first");
            Cache second = cm.getCache("second");
            StoreConfiguration firstCacheLoaderConfig = (StoreConfiguration)first.getCacheConfiguration().persistence().stores().get(0);
            StoreConfiguration secondCacheLoaderConfig = (StoreConfiguration)second.getCacheConfiguration().persistence().stores().get(0);
            AssertJUnit.assertEquals(JdbcStringBasedStoreConfiguration.class, firstCacheLoaderConfig.getClass());
            AssertJUnit.assertEquals(JdbcStringBasedStoreConfiguration.class, secondCacheLoaderConfig.getClass());
            JdbcStringBasedStore firstCs = (JdbcStringBasedStore)TestingUtil.getFirstLoader((Cache)first);
            JdbcStringBasedStore secondCs = (JdbcStringBasedStore)TestingUtil.getFirstLoader((Cache)second);
            this.assertTableExistence(firstCs.getConnectionFactory().getConnection(), firstCs.getTableManager().getIdentifierQuoteString(), "second", "first", "ISPN_STRING_TABLE");
            this.assertNoOverlapingState(first, second, (CacheLoader)firstCs, (CacheLoader)secondCs);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
            throw throwable;
        }
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{cm});
    }

    private void assertTableExistence(Connection connection, String identifierQuote, String secondTable, String firstTable, String tablePrefix) throws Exception {
        assert (!TableManagerTest.existsTable(connection, new TableName(identifierQuote, tablePrefix, ""))) : "this table should not exist!";
        assert (TableManagerTest.existsTable(connection, new TableName(identifierQuote, tablePrefix, firstTable)));
        assert (TableManagerTest.existsTable(connection, new TableName(identifierQuote, tablePrefix, secondTable)));
        connection.close();
    }

    private void assertNoOverlapingState(Cache first, Cache second, CacheLoader firstCs, CacheLoader secondCs) throws PersistenceException {
        first.put((Object)"k", (Object)"v");
        assert (firstCs.contains((Object)"k"));
        assert (!secondCs.contains((Object)"k"));
        assert (first.get((Object)"k").equals("v"));
        assert (second.get((Object)"k") == null);
        second.put((Object)"k2", (Object)"v2");
        assert (second.get((Object)"k2").equals("v2"));
        assert (first.get((Object)"k2") == null);
    }

    static class Person
    implements Serializable,
    ExternalPojo {
        int age;
        String name;
        private static final long serialVersionUID = 4227565864228124235L;

        Person(int age, String name) {
            this.age = age;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Person)) {
                return false;
            }
            Person person = (Person)o;
            if (this.age != person.age) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(person.name) : person.name != null);
        }

        public int hashCode() {
            int result = this.age;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}

