/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.HashSet;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.connectionfactory.C3P0ConnectionPool;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionPool;
import org.infinispan.persistence.jdbc.connectionfactory.HikariConnectionPool;
import org.infinispan.persistence.jdbc.connectionfactory.PooledConnectionFactory;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.PooledConnectionFactoryTest")
public class PooledConnectionFactoryTest {
    private PooledConnectionFactory factory;
    private JdbcStringBasedStoreConfigurationBuilder storeBuilder;
    private ConnectionFactoryConfigurationBuilder<?> factoryBuilder;

    @BeforeMethod
    public void beforeMethod() {
        this.factory = new PooledConnectionFactory();
    }

    @AfterMethod
    public void destroyFactory() {
        this.factory.stop();
        System.setProperty("infinispan.jdbc.c3p0.force", "false");
    }

    @Test
    public void testHikariValuesNoOverrides() throws Exception {
        this.testValuesNoOverrides();
    }

    @Test(groups={"unstable"}, description="See ISPN-3522")
    public void testC3P0ValuesNoOverrides() throws Exception {
        System.setProperty("infinispan.jdbc.c3p0.force", "true");
        this.testValuesNoOverrides();
    }

    private void testValuesNoOverrides() throws Exception {
        this.storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        this.factoryBuilder = UnitTestDatabaseManager.configureUniqueConnectionFactory(this.storeBuilder);
        ConnectionFactoryConfiguration factoryConfiguration = (ConnectionFactoryConfiguration)this.factoryBuilder.create();
        this.factory.start(factoryConfiguration, Thread.currentThread().getContextClassLoader());
        int hardcodedMaxPoolSize = this.factory.getMaxPoolSize();
        HashSet<Connection> connections = new HashSet<Connection>();
        for (int i = 0; i < hardcodedMaxPoolSize; ++i) {
            connections.add(this.factory.getConnection());
        }
        assert (connections.size() == hardcodedMaxPoolSize);
        assert (this.factory.getNumBusyConnectionsAllUsers() == hardcodedMaxPoolSize);
        for (Connection conn : connections) {
            conn.close();
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 2000L && this.factory.getNumBusyConnectionsAllUsers() != 0) {
        }
        assert (this.factory.getNumBusyConnectionsAllUsers() == 0);
    }

    @Test(expectedExceptions={PersistenceException.class})
    public void testC3PONoDriverClassFound() throws Exception {
        System.setProperty("infinispan.jdbc.c3p0.force", "true");
        this.testNoDriverClassFound();
    }

    @Test(expectedExceptions={PersistenceException.class})
    public void testHikariCPNoDriverClassFound() throws Exception {
        this.testNoDriverClassFound();
    }

    private void testNoDriverClassFound() throws Exception {
        this.storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        this.factoryBuilder = UnitTestDatabaseManager.configureBrokenConnectionFactory(this.storeBuilder);
        ConnectionFactoryConfiguration factoryConfiguration = (ConnectionFactoryConfiguration)this.factoryBuilder.create();
        this.factory.start(factoryConfiguration, Thread.currentThread().getContextClassLoader());
    }

    @Test
    public void testHikariCPLoaded() throws Exception {
        this.testConnectionPoolLoaded(HikariConnectionPool.class);
    }

    @Test
    public void testC3POLoaded() throws Exception {
        System.setProperty("infinispan.jdbc.c3p0.force", "true");
        this.testConnectionPoolLoaded(C3P0ConnectionPool.class);
    }

    private void testConnectionPoolLoaded(Class connectionPoolType) throws Exception {
        this.storeBuilder = (JdbcStringBasedStoreConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        this.factoryBuilder = UnitTestDatabaseManager.configureUniqueConnectionFactory(this.storeBuilder);
        ConnectionFactoryConfiguration factoryConfiguration = (ConnectionFactoryConfiguration)this.factoryBuilder.create();
        this.factory.start(factoryConfiguration, Thread.currentThread().getContextClassLoader());
        Field field = this.factory.getClass().getDeclaredField("connectionPool");
        field.setAccessible(true);
        ConnectionPool connectionPool = (ConnectionPool)field.get(this.factory);
        assert (connectionPool != null);
        assert (connectionPoolType.isInstance(connectionPool));
    }
}

