/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.table.management;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.infinispan.persistence.jdbc.JdbcUtil;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.jdbc.table.management.AbstractTableManager;
import org.infinispan.persistence.jdbc.table.management.DbMetaData;
import org.infinispan.persistence.jdbc.table.management.TableName;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

class OracleTableManager
extends AbstractTableManager {
    private static final Log LOG = (Log)LogFactory.getLog(OracleTableManager.class, Log.class);
    private static final int MAX_INDEX_IDENTIFIER_SIZE = 30;
    private static final String INDEX_PREFIX = "IDX";

    OracleTableManager(ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData) {
        super(connectionFactory, config, metaData, LOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableExists(Connection connection, TableName tableName) throws PersistenceException {
        Objects.requireNonNull(tableName, "table name is mandatory");
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String schemaPattern = tableName.getSchema() == null ? metaData.getUserName() : tableName.getSchema();
            rs = metaData.getTables(null, schemaPattern, tableName.getName(), new String[]{"TABLE"});
            boolean bl = rs.next();
            JdbcUtil.safeClose(rs);
            return bl;
        }
        catch (SQLException e) {
            if (LOG.isTraceEnabled()) {
                LOG.tracef(e, "SQLException occurs while checking the table %s", tableName);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            JdbcUtil.safeClose(rs);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean timestampIndexExists(Connection conn) throws PersistenceException {
        ResultSet rs;
        block6: {
            boolean bl;
            block5: {
                rs = null;
                try {
                    DatabaseMetaData meta = conn.getMetaData();
                    rs = meta.getIndexInfo(null, null, this.getTableName().toString(), false, false);
                    String indexName = this.getIndexName(false);
                    while (rs.next()) {
                        if (!indexName.equalsIgnoreCase(rs.getString("INDEX_NAME"))) continue;
                        bl = true;
                        break block5;
                    }
                    break block6;
                }
                catch (SQLException e) {
                    try {
                        throw new PersistenceException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        JdbcUtil.safeClose(rs);
                        throw throwable;
                    }
                }
            }
            JdbcUtil.safeClose(rs);
            return bl;
        }
        JdbcUtil.safeClose(rs);
        return false;
    }

    @Override
    public String getIndexName(boolean withIdentifier) {
        String tableName;
        int maxNameSize = 30 - INDEX_PREFIX.length() - 1;
        if (withIdentifier) {
            maxNameSize -= 2;
        }
        String truncatedName = (tableName = this.getTableName().toString().replace(this.identifierQuoteString, "")).length() > maxNameSize ? tableName.substring(0, maxNameSize) : tableName;
        String indexName = "IDX_" + truncatedName;
        if (withIdentifier) {
            return this.identifierQuoteString + indexName + this.identifierQuoteString;
        }
        return indexName;
    }

    @Override
    public String getUpsertRowSql() {
        if (this.upsertRowSql == null) {
            this.upsertRowSql = String.format("MERGE INTO %1$s t USING (SELECT ? %2$s, ? %3$s, ? %4$s from dual) tmp ON (t.%4$s = tmp.%4$s) WHEN MATCHED THEN UPDATE SET t.%2$s = tmp.%2$s, t.%3$s = tmp.%3$s WHEN NOT MATCHED THEN INSERT VALUES (tmp.%4$s, tmp.%2$s, tmp.%3$s)", this.getTableName(), this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName());
        }
        return this.upsertRowSql;
    }
}

