/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.table.management;

import java.sql.Connection;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.jdbc.table.management.AbstractTableManager;
import org.infinispan.persistence.jdbc.table.management.DbMetaData;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

class H2TableManager
extends AbstractTableManager {
    private static final Log LOG = (Log)LogFactory.getLog(H2TableManager.class, Log.class);

    H2TableManager(ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData) {
        super(connectionFactory, config, metaData, LOG);
    }

    @Override
    public String getUpsertRowSql() {
        if (this.upsertRowSql == null) {
            this.upsertRowSql = String.format("MERGE INTO %1$s (%2$s, %3$s, %4$s) KEY(%4$s) VALUES(?, ?, ?)", this.getTableName(), this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName());
        }
        return this.upsertRowSql;
    }

    @Override
    protected void dropTimestampIndex(Connection conn) throws PersistenceException {
        String dropIndexDdl = String.format("DROP INDEX IF EXISTS  %s", this.getIndexName(true));
        this.executeUpdateSql(conn, dropIndexDdl);
    }
}

