/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import java.sql.Connection;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationChildBuilder;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.connectionfactory.PooledConnectionFactory;
import org.infinispan.persistence.jdbc.stringbased.Person;
import org.infinispan.persistence.jdbc.stringbased.PersonKey2StringMapper;
import org.infinispan.persistence.jdbc.stringbased.TwoWayPersonKey2StringMapper;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.stringbased.NonStringKeyPreloadTest")
public class NonStringKeyPreloadTest
extends AbstractInfinispanTest {
    public void testPreloadWithKey2StringMapper() throws Exception {
        String mapperName = PersonKey2StringMapper.class.getName();
        ConfigurationBuilder cfg = NonStringKeyPreloadTest.createCacheStoreConfig(mapperName, false, true);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg)){

            public void call() {
                try {
                    this.cm.getCache();
                    assert (false) : " Preload with Key2StringMapper is not supported. Specify an TwoWayKey2StringMapper if you want to support it (or disable preload).";
                }
                catch (CacheException e) {
                    NonStringKeyPreloadTest.this.log.debugf("Ignoring expected exception", (Object)e);
                }
            }
        });
    }

    public void testPreloadWithTwoWayKey2StringMapper() throws Exception {
        String mapperName = TwoWayPersonKey2StringMapper.class.getName();
        ConfigurationBuilder config = NonStringKeyPreloadTest.createCacheStoreConfig(mapperName, true, true);
        final Person mircea = new Person("Markus", "Mircea", 30);
        final Person dan = new Person("Dan", "Dude", 30);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)config)){

            public void call() {
                Cache cache = this.cm.getCache();
                cache.put((Object)mircea, (Object)"me");
                cache.put((Object)dan, (Object)"mate");
            }
        });
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)config)){

            public void call() {
                Cache cache = null;
                try {
                    cache = this.cm.getCache();
                    assert (cache.containsKey((Object)mircea));
                    assert (cache.containsKey((Object)dan));
                }
                finally {
                    TestingUtil.clearCacheLoader((Cache)cache);
                }
            }
        });
    }

    public void testPreloadWithTwoWayKey2StringMapperAndBoundedCache() throws Exception {
        String mapperName = TwoWayPersonKey2StringMapper.class.getName();
        ConfigurationBuilder config = NonStringKeyPreloadTest.createCacheStoreConfig(mapperName, true, true);
        config.memory().size(3L);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)config)){

            public void call() {
                AdvancedCache cache = this.cm.getCache().getAdvancedCache();
                for (int i = 0; i < 10; ++i) {
                    Person p = new Person("name" + i, "surname" + i, 30);
                    cache.put((Object)p, (Object)("" + i));
                }
            }
        });
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)config)){

            public void call() {
                AdvancedCache cache = this.cm.getCache().getAdvancedCache();
                AssertJUnit.assertEquals((int)3, (int)cache.getDataContainer().size());
                int found = 0;
                for (int i = 0; i < 10; ++i) {
                    Person p = new Person("name" + i, "surname" + i, 30);
                    if (!cache.getDataContainer().containsKey((Object)p)) continue;
                    ++found;
                }
                AssertJUnit.assertEquals((int)3, (int)found);
            }
        });
    }

    static ConfigurationBuilder createCacheStoreConfig(String mapperName, boolean wrap, boolean preload) {
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcStringBasedStoreConfigurationBuilder store = ((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)cfg.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).fetchPersistentState(true)).preload(preload)).key2StringMapper(mapperName);
        UnitTestDatabaseManager.buildTableManipulation(store.table());
        if (wrap) {
            ConnectionFactoryConfigurationBuilder<?> tmp = UnitTestDatabaseManager.configureUniqueConnectionFactory((AbstractJdbcStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class));
            ((SharedConnectionFactoryConfigurationBuilder)store.connectionFactory(new SharedConnectionFactoryConfigurationBuilder(store))).read((PooledConnectionFactoryConfiguration)tmp.create());
        } else {
            UnitTestDatabaseManager.configureUniqueConnectionFactory(store);
        }
        return cfg;
    }

    public static class SharedConnectionFactoryConfigurationBuilder<S extends AbstractJdbcStoreConfigurationBuilder<?, S>>
    extends AbstractJdbcStoreConfigurationChildBuilder<S>
    implements ConnectionFactoryConfigurationBuilder<SharedConnectionFactoryConfiguration> {
        private String connectionUrl;
        private String driverClass;
        private String username;
        private String password;

        public SharedConnectionFactoryConfigurationBuilder(AbstractJdbcStoreConfigurationBuilder<?, S> builder) {
            super(builder);
        }

        public void validate() {
        }

        public void validate(GlobalConfiguration globalConfig) {
        }

        public SharedConnectionFactoryConfiguration create() {
            return new SharedConnectionFactoryConfiguration(this.connectionUrl, this.driverClass, this.username, this.password);
        }

        public Builder<?> read(SharedConnectionFactoryConfiguration template) {
            this.connectionUrl = template.connectionUrl();
            this.driverClass = template.driverClass();
            this.username = template.username();
            this.password = template.password();
            return this;
        }

        public Builder<?> read(PooledConnectionFactoryConfiguration template) {
            this.connectionUrl = template.connectionUrl();
            this.driverClass = template.driverClass();
            this.username = template.username();
            this.password = template.password();
            return this;
        }
    }

    @BuiltBy(value=SharedConnectionFactoryConfigurationBuilder.class)
    public static class SharedConnectionFactoryConfiguration
    extends PooledConnectionFactoryConfiguration {
        SharedConnectionFactoryConfiguration(String connectionUrl, String driverClass, String username, String password) {
            super(null, connectionUrl, driverClass, username, password);
        }

        public Class<? extends ConnectionFactory> connectionFactoryClass() {
            return SharedConnectionFactory.class;
        }
    }

    public static class SharedConnectionFactory
    extends ConnectionFactory {
        static PooledConnectionFactory sharedFactory;
        static boolean started;

        public void start(ConnectionFactoryConfiguration config, ClassLoader classLoader) throws PersistenceException {
            if (!started) {
                sharedFactory = new PooledConnectionFactory();
                sharedFactory.start(config, classLoader);
                started = true;
            }
        }

        public void stop() {
        }

        public Connection getConnection() throws PersistenceException {
            return sharedFactory.getConnection();
        }

        public void releaseConnection(Connection conn) {
            sharedFactory.releaseConnection(conn);
        }

        static {
            started = false;
        }
    }
}

