/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.stringbased.Person;
import org.infinispan.persistence.jdbc.stringbased.PersonKey2StringMapper;
import org.infinispan.persistence.jdbc.stringbased.TwoWayPersonKey2StringMapper;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.UnitTestDatabaseManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.jdbc.stringbased.NonStringKeyPreloadTest")
public class NonStringKeyPreloadTest
extends AbstractInfinispanTest {
    public void testPreloadWithKey2StringMapper() throws Exception {
        String mapperName = PersonKey2StringMapper.class.getName();
        ConfigurationBuilder cfg = NonStringKeyPreloadTest.createCacheStoreConfig(mapperName, true);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg)){

            public void call() {
                try {
                    this.cm.getCache();
                    assert (false) : " Preload with Key2StringMapper is not supported. Specify an TwoWayKey2StringMapper if you want to support it (or disable preload).";
                }
                catch (CacheException e) {
                    NonStringKeyPreloadTest.this.log.debugf("Ignoring expected exception", (Object)e);
                }
            }
        });
    }

    public void testPreloadWithTwoWayKey2StringMapper() throws Exception {
        String mapperName = TwoWayPersonKey2StringMapper.class.getName();
        ConfigurationBuilder config = NonStringKeyPreloadTest.createCacheStoreConfig(mapperName, true);
        final Person mircea = new Person("Markus", "Mircea", 30);
        final Person dan = new Person("Dan", "Dude", 30);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)config)){

            public void call() {
                Cache cache = this.cm.getCache();
                cache.put((Object)mircea, (Object)"me");
                cache.put((Object)dan, (Object)"mate");
            }
        });
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)config)){

            public void call() {
                Cache cache = null;
                try {
                    cache = this.cm.getCache();
                    assert (cache.containsKey((Object)mircea));
                    assert (cache.containsKey((Object)dan));
                }
                finally {
                    TestingUtil.clearCacheLoader((Cache)cache);
                }
            }
        });
    }

    public void testPreloadWithTwoWayKey2StringMapperAndBoundedCache() throws Exception {
        String mapperName = TwoWayPersonKey2StringMapper.class.getName();
        ConfigurationBuilder config = NonStringKeyPreloadTest.createCacheStoreConfig(mapperName, true);
        config.memory().size(3L);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)config)){

            public void call() {
                AdvancedCache cache = this.cm.getCache().getAdvancedCache();
                for (int i = 0; i < 10; ++i) {
                    Person p = new Person("name" + i, "surname" + i, 30);
                    cache.put((Object)p, (Object)("" + i));
                }
            }
        });
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)config)){

            public void call() {
                AdvancedCache cache = this.cm.getCache().getAdvancedCache();
                AssertJUnit.assertEquals((int)3, (int)cache.getDataContainer().size());
                int found = 0;
                for (int i = 0; i < 10; ++i) {
                    Person p = new Person("name" + i, "surname" + i, 30);
                    if (!cache.getDataContainer().containsKey((Object)p)) continue;
                    ++found;
                }
                AssertJUnit.assertEquals((int)3, (int)found);
            }
        });
    }

    static ConfigurationBuilder createCacheStoreConfig(String mapperName, boolean preload) {
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        JdbcStringBasedStoreConfigurationBuilder store = ((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)cfg.persistence().connectionAttempts(1).addStore(JdbcStringBasedStoreConfigurationBuilder.class)).fetchPersistentState(true)).preload(preload)).key2StringMapper(mapperName);
        UnitTestDatabaseManager.buildTableManipulation(store.table());
        UnitTestDatabaseManager.configureUniqueConnectionFactory(store);
        return cfg;
    }
}

