/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.mongodb;

import java.util.UUID;
import org.infinispan.loaders.BaseCacheStoreTest;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.mongodb.MongoDBCacheStore;
import org.infinispan.loaders.mongodb.MongoDBCacheStoreConfig;
import org.infinispan.loaders.mongodb.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="loaders.remote.MongoDBCacheStoreTest", groups={"mongodb"})
public class MongoDBCacheStoreTest
extends BaseCacheStoreTest {
    private static final Log log = (Log)LogFactory.getLog(MongoDBCacheStoreTest.class, Log.class);
    private MongoDBCacheStore cacheStore;

    protected CacheStore createCacheStore() throws Exception {
        String hostname = System.getProperty("MONGODB_HOSTNAME");
        if (hostname == null || "".equals(hostname)) {
            hostname = "127.0.0.1";
        }
        int port = 27017;
        String configurationPort = System.getProperty("MONGODB_PORT");
        try {
            if (configurationPort != null && !"".equals(configurationPort)) {
                port = Integer.parseInt(configurationPort);
            }
        }
        catch (NumberFormatException e) {
            throw log.mongoPortIllegalValue((Object)configurationPort);
        }
        log.runningTest(hostname, port);
        MongoDBCacheStoreConfig config = new MongoDBCacheStoreConfig(hostname, port, 2000, "", "", UUID.randomUUID().toString(), "infinispan_indexes", -1);
        config.setPurgeSynchronously(Boolean.valueOf(true));
        this.cacheStore = new MongoDBCacheStore();
        this.cacheStore.init((CacheLoaderConfig)config, this.getCache(), this.getMarshaller());
        this.cacheStore.start();
        return this.cacheStore;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.cacheStore.drop();
    }
}

